/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;

public final class PrometheusTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final Optional<TupleDomain<ColumnHandle>> predicate;

    @JsonCreator
    public PrometheusTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this(schemaName, tableName, Optional.empty());
    }

    private PrometheusTableHandle(String schemaName, String tableName, Optional<TupleDomain<ColumnHandle>> predicate) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public Optional<TupleDomain<ColumnHandle>> getPredicate() {
        return this.predicate;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public PrometheusTableHandle withPredicate(TupleDomain<ColumnHandle> predicate) {
        return new PrometheusTableHandle(this.schemaName, this.tableName, Optional.of(predicate));
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrometheusTableHandle other = (PrometheusTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return this.schemaName + ":" + this.tableName;
    }
}

