/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.builtin;

import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.internal.ProtocolReader;
import io.airlift.drift.codec.internal.ProtocolWriter;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MapThriftCodec<K, V>
implements ThriftCodec<Map<K, V>> {
    private final ThriftType thriftType;
    private final ThriftCodec<K> keyCodec;
    private final ThriftCodec<V> valueCodec;

    public MapThriftCodec(ThriftType type, ThriftCodec<K> keyCodec, ThriftCodec<V> valueCodec) {
        this.thriftType = Objects.requireNonNull(type, "type is null");
        this.keyCodec = Objects.requireNonNull(keyCodec, "keyCodec is null");
        this.valueCodec = Objects.requireNonNull(valueCodec, "valueCodec is null");
    }

    @Override
    public ThriftType getType() {
        return this.thriftType;
    }

    @Override
    public Map<K, V> read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return new ProtocolReader(protocol).readMap(this.keyCodec, this.valueCodec);
    }

    @Override
    public void write(Map<K, V> value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        new ProtocolWriter(protocol).writeMap(this.keyCodec, this.valueCodec, value);
    }
}

