/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.util;

import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.BeanDescription;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JavaType;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.PropertyName;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.cfg.MapperConfig;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedClass;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.type.ClassKey;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public PropertyName findRootName(Class<?> rootType, MapperConfig<?> config) {
        AnnotatedClass ac;
        ClassKey key = new ClassKey(rootType);
        PropertyName name = this._rootNames.get(key);
        if (name != null) {
            return name;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        name = intr.findRootName(ac = beanDesc.getClassInfo());
        if (name == null || !name.hasSimpleName()) {
            name = new PropertyName(rootType.getSimpleName());
        }
        this._rootNames.put(key, name);
        return name;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

