/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import io.trino.hadoop.$internal.org.apache.kerby.KOptions;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminConfig;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminOption;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminSetting;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminUtil;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.RemoteKadminImpl;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl.DefaultInternalAdminClient;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl.InternalAdminClient;
import java.io.File;
import java.util.List;

public class AdminClient {
    private final AdminConfig adminConfig;
    private final KOptions commonOptions;
    private final AdminSetting adminSetting;
    private InternalAdminClient innerClient;

    public AdminClient() throws KrbException {
        this.adminConfig = AdminUtil.getDefaultConfig();
        this.commonOptions = new KOptions();
        this.adminSetting = new AdminSetting(this.commonOptions, this.adminConfig);
    }

    public AdminClient(AdminConfig adminConfig) {
        this.adminConfig = adminConfig;
        this.commonOptions = new KOptions();
        this.adminSetting = new AdminSetting(this.commonOptions, adminConfig);
    }

    public AdminClient(File confDir) throws KrbException {
        this.commonOptions = new KOptions();
        this.adminConfig = AdminUtil.getConfig(confDir);
        this.adminSetting = new AdminSetting(this.commonOptions, this.adminConfig);
    }

    public AdminClient(AdminClient krbClient) {
        this.commonOptions = krbClient.commonOptions;
        this.adminConfig = krbClient.adminConfig;
        this.adminSetting = krbClient.adminSetting;
        this.innerClient = krbClient.innerClient;
    }

    public void setAdminRealm(String realm) {
        this.commonOptions.add(AdminOption.ADMIN_REALM, realm);
    }

    public void setKeyTabFile(File file) {
        this.commonOptions.add(AdminOption.KEYTAB_FILE, file);
    }

    public void setKdcHost(String kdcHost) {
        this.commonOptions.add(AdminOption.ADMIN_HOST, kdcHost);
    }

    public void setAdminTcpPort(int kdcTcpPort) {
        if (kdcTcpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add(AdminOption.ADMIN_TCP_PORT, kdcTcpPort);
        this.setAllowTcp(true);
    }

    public void setAllowUdp(boolean allowUdp) {
        this.commonOptions.add(AdminOption.ALLOW_UDP, allowUdp);
    }

    public void setAllowTcp(boolean allowTcp) {
        this.commonOptions.add(AdminOption.ALLOW_TCP, allowTcp);
    }

    public void setAdminUdpPort(int adminUdpPort) {
        if (adminUdpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add(AdminOption.ADMIN_UDP_PORT, adminUdpPort);
        this.setAllowUdp(true);
    }

    public void setTimeout(int timeout) {
        this.commonOptions.add(AdminOption.CONN_TIMEOUT, timeout);
    }

    public void init() throws KrbException {
        this.innerClient = new DefaultInternalAdminClient(this.adminSetting);
        this.innerClient.init();
    }

    public AdminSetting getSetting() {
        return this.adminSetting;
    }

    public AdminConfig getAdminConfig() {
        return this.adminConfig;
    }

    public void requestAddPrincipal(String principal) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        remote.addPrincipal(principal);
    }

    public void requestAddPrincipal(String principal, String password) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        remote.addPrincipal(principal, password);
    }

    public void requestDeletePrincipal(String principal) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        remote.deletePrincipal(principal);
    }

    public void requestRenamePrincipal(String oldPrincipal, String newPrincipal) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        remote.renamePrincipal(oldPrincipal, newPrincipal);
    }

    public List<String> requestGetprincs() throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        List<String> principalLists = remote.getPrincipals();
        return principalLists;
    }

    public List<String> requestGetprincsWithExp(String exp) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        List<String> principalLists = remote.getPrincipals(exp);
        return principalLists;
    }
}

