/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.ReadBufferManager;

public class AbfsInputStream
extends FSInputStream {
    private final AbfsClient client;
    private final FileSystem.Statistics statistics;
    private final String path;
    private final long contentLength;
    private final int bufferSize;
    private final int readAheadQueueDepth;
    private final String eTag;
    private final boolean tolerateOobAppends;
    private final boolean readAheadEnabled;
    private byte[] buffer = null;
    private long fCursor = 0L;
    private long fCursorAfterLastRead = -1L;
    private int bCursor = 0;
    private int limit = 0;
    private boolean closed = false;

    public AbfsInputStream(AbfsClient client, FileSystem.Statistics statistics, String path, long contentLength, int bufferSize, int readAheadQueueDepth, String eTag) {
        this.client = client;
        this.statistics = statistics;
        this.path = path;
        this.contentLength = contentLength;
        this.bufferSize = bufferSize;
        this.readAheadQueueDepth = readAheadQueueDepth >= 0 ? readAheadQueueDepth : Runtime.getRuntime().availableProcessors();
        this.eTag = eTag;
        this.tolerateOobAppends = false;
        this.readAheadEnabled = true;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int numberOfBytesRead = this.read(b, 0, 1);
        if (numberOfBytesRead < 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int lastReadBytes;
        int currentOff = off;
        int currentLen = len;
        int totalReadBytes = 0;
        do {
            if ((lastReadBytes = this.readOneBlock(b, currentOff, currentLen)) <= 0) continue;
            currentOff += lastReadBytes;
            currentLen -= lastReadBytes;
            totalReadBytes += lastReadBytes;
        } while (currentLen > 0 && currentLen <= b.length - currentOff && lastReadBytes > 0);
        return totalReadBytes > 0 ? totalReadBytes : lastReadBytes;
    }

    private int readOneBlock(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        Preconditions.checkNotNull(b);
        if (len == 0) {
            return 0;
        }
        if (this.available() == 0) {
            return -1;
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bCursor == this.limit) {
            if (this.fCursor >= this.contentLength) {
                return -1;
            }
            long bytesRead = 0L;
            this.bCursor = 0;
            this.limit = 0;
            if (this.buffer == null) {
                this.buffer = new byte[this.bufferSize];
            }
            if ((bytesRead = -1L == this.fCursorAfterLastRead || this.fCursorAfterLastRead == this.fCursor || b.length >= this.bufferSize ? (long)this.readInternal(this.fCursor, this.buffer, 0, this.bufferSize, false) : (long)this.readInternal(this.fCursor, this.buffer, 0, b.length, true)) == -1L) {
                return -1;
            }
            this.limit = (int)((long)this.limit + bytesRead);
            this.fCursor += bytesRead;
            this.fCursorAfterLastRead = this.fCursor;
        }
        int bytesRemaining = this.limit - this.bCursor;
        int bytesToRead = Math.min(len, bytesRemaining);
        System.arraycopy(this.buffer, this.bCursor, b, off, bytesToRead);
        this.bCursor += bytesToRead;
        if (this.statistics != null) {
            this.statistics.incrementBytesRead(bytesToRead);
        }
        return bytesToRead;
    }

    private int readInternal(long position, byte[] b, int offset, int length, boolean bypassReadAhead) throws IOException {
        if (this.readAheadEnabled && !bypassReadAhead) {
            long nextSize;
            if (offset != 0) {
                throw new IllegalArgumentException("readahead buffers cannot have non-zero buffer offsets");
            }
            int numReadAheads = this.readAheadQueueDepth;
            for (long nextOffset = position; numReadAheads > 0 && nextOffset < this.contentLength; nextOffset += nextSize, --numReadAheads) {
                nextSize = Math.min((long)this.bufferSize, this.contentLength - nextOffset);
                ReadBufferManager.getBufferManager().queueReadAhead(this, nextOffset, (int)nextSize);
            }
            int receivedBytes = ReadBufferManager.getBufferManager().getBlock(this, position, length, b);
            if (receivedBytes > 0) {
                return receivedBytes;
            }
            receivedBytes = this.readRemote(position, b, offset, length);
            return receivedBytes;
        }
        return this.readRemote(position, b, offset, length);
    }

    int readRemote(long position, byte[] b, int offset, int length) throws IOException {
        AbfsRestOperation op;
        if (position < 0L) {
            throw new IllegalArgumentException("attempting to read from negative offset");
        }
        if (position >= this.contentLength) {
            return -1;
        }
        if (b == null) {
            throw new IllegalArgumentException("null byte array passed in to read() method");
        }
        if (offset >= b.length) {
            throw new IllegalArgumentException("offset greater than length of array");
        }
        if (length < 0) {
            throw new IllegalArgumentException("requested read length is less than zero");
        }
        if (length > b.length - offset) {
            throw new IllegalArgumentException("requested read length is more than will fit after requested offset in buffer");
        }
        try {
            op = this.client.read(this.path, position, b, offset, length, this.tolerateOobAppends ? "*" : this.eTag);
        }
        catch (AzureBlobFileSystemException ex) {
            throw new IOException(ex);
        }
        long bytesRead = op.getResult().getBytesReceived();
        if (bytesRead > Integer.MAX_VALUE) {
            throw new IOException("Unexpected Content-Length");
        }
        return (int)bytesRead;
    }

    @Override
    public synchronized void seek(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        if (n < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (n > this.contentLength) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        if (n >= this.fCursor - (long)this.limit && n <= this.fCursor) {
            this.bCursor = (int)(n - (this.fCursor - (long)this.limit));
            return;
        }
        this.fCursor = n;
        this.limit = 0;
        this.bCursor = 0;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        long currentPos = this.getPos();
        if (currentPos == this.contentLength && n > 0L) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        long newPos = currentPos + n;
        if (newPos < 0L) {
            newPos = 0L;
            n = newPos - currentPos;
        }
        if (newPos > this.contentLength) {
            newPos = this.contentLength;
            n = newPos - currentPos;
        }
        this.seek(newPos);
        return n;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        long remaining = this.contentLength - this.getPos();
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    public long length() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        return this.contentLength;
    }

    @Override
    public synchronized long getPos() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        return this.fCursor - (long)this.limit + (long)this.bCursor;
    }

    @Override
    public boolean seekToNewSource(long l) throws IOException {
        return false;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.buffer = null;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark()/reset() not supported on this stream");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("mark()/reset() not supported on this stream");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

