/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.util.Collection;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;

public class BlockStorageMovementCommand
extends DatanodeCommand {
    private final String blockPoolId;
    private final Collection<BlockMovingInfo> blockMovingTasks;

    public BlockStorageMovementCommand(int action, String blockPoolId, Collection<BlockMovingInfo> blockMovingInfos) {
        super(action);
        this.blockPoolId = blockPoolId;
        this.blockMovingTasks = blockMovingInfos;
    }

    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public Collection<BlockMovingInfo> getBlockMovingTasks() {
        return this.blockMovingTasks;
    }

    public static class BlockMovingInfo {
        private Block blk;
        private DatanodeInfo sourceNode;
        private DatanodeInfo targetNode;
        private StorageType sourceStorageType;
        private StorageType targetStorageType;

        public BlockMovingInfo(Block block, DatanodeInfo sourceDnInfo, DatanodeInfo targetDnInfo, StorageType srcStorageType, StorageType targetStorageType) {
            this.blk = block;
            this.sourceNode = sourceDnInfo;
            this.targetNode = targetDnInfo;
            this.sourceStorageType = srcStorageType;
            this.targetStorageType = targetStorageType;
        }

        public void addBlock(Block block) {
            this.blk = block;
        }

        public Block getBlock() {
            return this.blk;
        }

        public DatanodeInfo getSource() {
            return this.sourceNode;
        }

        public DatanodeInfo getTarget() {
            return this.targetNode;
        }

        public StorageType getTargetStorageType() {
            return this.targetStorageType;
        }

        public StorageType getSourceStorageType() {
            return this.sourceStorageType;
        }

        public String toString() {
            return "BlockMovingInfo(\n  " + "Moving block: " + this.blk + " From: " + this.sourceNode + " To: [" + this.targetNode + "\n  " + " sourceStorageType: " + (Object)((Object)this.sourceStorageType) + " targetStorageType: " + (Object)((Object)this.targetStorageType) + ")";
        }
    }
}

