/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.shaded.shaded.common.collect.Range;
import com.google.shaded.shaded.common.util.concurrent.MoreExecutors;
import com.google.shaded.shaded.common.util.concurrent.ThreadFactoryBuilder;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.DownloadRequestContext;
import com.qubole.rubix.bookkeeper.FileDownloadRequestChain;
import com.qubole.rubix.bookkeeper.RemoteFetchProcessor;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.core.CachingFileSystemStatsProvider;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.CommonUtilities;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.CacheStatusResponse;
import com.qubole.rubix.spi.thrift.Location;
import com.qubole.rubix.spi.utils.DataSizeUnits;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DirectBufferPool;

class FileDownloader {
    Configuration conf;
    private ExecutorService processService;
    int diskReadBufferSize;
    private MetricRegistry metrics;
    private Counter totalMBDownloaded;
    private Counter totalTimeToDownload;
    private final RemoteFetchProcessor remoteFetchProcessor;
    private final BookKeeper bookKeeper;
    private final CachingFileSystemStatsProvider stats;
    private static final Log log = LogFactory.getLog(FileDownloader.class);
    private static DirectBufferPool bufferPool = new DirectBufferPool();

    public FileDownloader(BookKeeper bookKeeper, MetricRegistry metrics, Configuration conf, RemoteFetchProcessor remoteFetchProcessor, CachingFileSystemStatsProvider stats) {
        this.bookKeeper = bookKeeper;
        this.remoteFetchProcessor = remoteFetchProcessor;
        this.conf = conf;
        this.metrics = metrics;
        int numThreads = CacheConfig.getRemoteFetchThreads(conf);
        this.diskReadBufferSize = CacheConfig.getDiskReadBufferSize(conf);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("parallel-warmup-%s").setDaemon(true).build());
        this.processService = MoreExecutors.getExitingExecutorService(executor);
        this.stats = stats;
        this.initializeMetrics();
    }

    private void initializeMetrics() {
        this.totalMBDownloaded = this.metrics.counter(BookKeeperMetrics.CacheMetric.ASYNC_DOWNLOADED_MB_COUNT.getMetricName());
        this.totalTimeToDownload = this.metrics.counter(BookKeeperMetrics.CacheMetric.ASYNC_DOWNLOAD_TIME_COUNT.getMetricName());
    }

    protected List<FileDownloadRequestChain> getFileDownloadRequestChains(ConcurrentMap<String, DownloadRequestContext> contextMap) throws IOException {
        ArrayList<FileDownloadRequestChain> readRequestChainList = new ArrayList<FileDownloadRequestChain>();
        for (Map.Entry entry : contextMap.entrySet()) {
            Path path = new Path((String)entry.getKey());
            DownloadRequestContext context = (DownloadRequestContext)entry.getValue();
            int generationNumber = 0;
            FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)this.conf);
            fs.initialize(path.toUri(), this.conf);
            ByteBuffer directWriteBuffer = bufferPool.getBuffer(this.diskReadBufferSize);
            FileDownloadRequestChain requestChain = null;
            String remotePath = (String)entry.getKey();
            Range<Long> previousRange = null;
            for (Range<Long> range : context.getRanges().asRanges()) {
                List<BlockLocation> blockLocations;
                long startBlock;
                block6: {
                    startBlock = CommonUtilities.toStartBlock((long)range.lowerEndpoint(), this.conf);
                    long endBlock = CommonUtilities.toEndBlock((long)range.upperEndpoint(), this.conf);
                    Range<Long> currentRange = Range.closedOpen(startBlock, endBlock);
                    if (previousRange != null && previousRange.encloses(currentRange)) continue;
                    previousRange = currentRange;
                    blockLocations = null;
                    try {
                        CacheStatusResponse response = this.bookKeeper.getCacheStatus(new CacheStatusRequest(context.getRemoteFilePath(), context.getFileSize(), context.getLastModifiedTime(), startBlock, endBlock));
                        blockLocations = response.getBlocks();
                        if (generationNumber != 0 && response.getGenerationNumber() != generationNumber) {
                            log.debug((Object)String.format("Mismatch in generation-number in download requests for file %s, expected=%d but found=%d, skipping the file", remotePath, generationNumber, response.getGenerationNumber()));
                            requestChain = null;
                            break;
                        }
                        generationNumber = response.getGenerationNumber();
                        if (requestChain != null) break block6;
                        String localPath = CacheUtil.getLocalPath(remotePath, this.conf, generationNumber);
                        log.debug((Object)("Processing Request for File : " + path.toString() + " LocalFile : " + localPath));
                        requestChain = new FileDownloadRequestChain(this.bookKeeper, fs, localPath, directWriteBuffer, this.conf, context.getRemoteFilePath(), context.getFileSize(), context.getLastModifiedTime(), generationNumber);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error communicating with bookKeeper", (Throwable)e);
                        this.remoteFetchProcessor.addToProcessQueueSafe(context.getRemoteFilePath(), context.getRanges().asRanges(), context.getFileSize(), context.getLastModifiedTime());
                        requestChain = null;
                        break;
                    }
                }
                for (int i = 0; i < blockLocations.size(); ++i) {
                    if (!blockLocations.get(i).getLocation().equals(Location.LOCAL)) continue;
                    long block = startBlock + (long)i;
                    long startPosition = CommonUtilities.toBlockStartPosition(block, this.conf);
                    long endPosition = Math.min(CommonUtilities.toBlockStartPosition(block + 1L, this.conf), context.getFileSize());
                    ReadRequest readRequest = new ReadRequest(startPosition, endPosition, startPosition, endPosition, null, 0, context.getFileSize());
                    requestChain.addReadRequest(readRequest);
                }
            }
            if (requestChain == null) continue;
            log.debug((Object)("Request added for file: " + requestChain.getRemotePath() + " Number of Requests : " + requestChain.getReadRequests().size()));
            readRequestChainList.add(requestChain);
        }
        return readRequestChainList;
    }

    protected long processDownloadRequests(List<FileDownloadRequestChain> readRequestChainList) {
        if (readRequestChainList.size() == 0) {
            return 0L;
        }
        long sizeRead = 0L;
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
        for (FileDownloadRequestChain fileDownloadRequestChain : readRequestChainList) {
            fileDownloadRequestChain.lock();
            Future<Long> result = this.processService.submit(fileDownloadRequestChain);
            futures.add(result);
        }
        for (Future future : futures) {
            FileDownloadRequestChain requestChain = readRequestChainList.get(futures.indexOf(future));
            long totalBytesToBeDownloaded = 0L;
            for (ReadRequest request : requestChain.getReadRequests()) {
                totalBytesToBeDownloaded += request.getBackendReadLength();
            }
            try {
                long read = (Long)future.get();
                if (read == totalBytesToBeDownloaded) {
                    this.stats.addReadRequestChainStats(requestChain.getStats());
                    sizeRead += read;
                    this.totalTimeToDownload.inc(requestChain.getTimeSpentOnDownload());
                    continue;
                }
                log.error((Object)("ReadData didn't match with requested value. RequestedData: " + totalBytesToBeDownloaded + " ReadData: " + read));
            }
            catch (InterruptedException | ExecutionException ex) {
                if (ex.getCause() instanceof FileNotFoundException) {
                    log.debug((Object)("Could not process download request: " + ex.getCause().getMessage()));
                } else {
                    log.error((Object)"Could not process download request", (Throwable)ex);
                }
                requestChain.cancel();
            }
        }
        long dataDownloadedInMB = DataSizeUnits.BYTES.toMB(sizeRead);
        this.totalMBDownloaded.inc(dataDownloadedInMB);
        return sizeRead;
    }
}

