/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrTcpDecodingStream
extends XdrDecodingStream {
    private Socket socket;
    InputStream stream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private int fragmentLength;
    private boolean lastFragment;

    public XdrTcpDecodingStream(Socket streamingSocket, int bufferSize) throws IOException {
        this.socket = streamingSocket;
        this.stream = this.socket.getInputStream();
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[bufferSize];
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
        this.lastFragment = false;
        this.fragmentLength = 0;
    }

    public InetAddress getSenderAddress() {
        return this.socket.getInetAddress();
    }

    public int getSenderPort() {
        return this.socket.getPort();
    }

    public void beginDecoding() throws OncRpcException, IOException {
        this.fill();
    }

    private void readBuffer(InputStream stream, byte[] bytes, int bytesToRead) throws IOException, OncRpcException {
        int byteOffset = 0;
        while (bytesToRead > 0) {
            int bytesRead = stream.read(bytes, byteOffset, bytesToRead);
            if (bytesRead <= 0) {
                throw new OncRpcException(4);
            }
            bytesToRead -= bytesRead;
            byteOffset += bytesRead;
        }
    }

    private void fill() throws OncRpcException, IOException {
        if (this.fragmentLength <= 0) {
            if (this.lastFragment) {
                throw new OncRpcException(43);
            }
            byte[] bytes = new byte[4];
            this.readBuffer(this.stream, bytes, 4);
            this.fragmentLength = bytes[0] & 0xFF;
            this.fragmentLength = (this.fragmentLength << 8) + (bytes[1] & 0xFF);
            this.fragmentLength = (this.fragmentLength << 8) + (bytes[2] & 0xFF);
            this.fragmentLength = (this.fragmentLength << 8) + (bytes[3] & 0xFF);
            if ((this.fragmentLength & Integer.MIN_VALUE) != 0) {
                this.fragmentLength &= Integer.MAX_VALUE;
                this.lastFragment = true;
            } else {
                this.lastFragment = false;
            }
            if ((this.fragmentLength & 3) != 0) {
                throw new IOException("ONC/RPC XDR fragment length is not a multiple of four");
            }
            if (this.fragmentLength == 0 && !this.lastFragment) {
                throw new IOException("empty ONC/RPC XDR fragment which is not a trailing fragment");
            }
        }
        this.bufferIndex = 0;
        if (this.fragmentLength < this.buffer.length) {
            this.readBuffer(this.stream, this.buffer, this.fragmentLength);
            this.bufferHighmark = this.fragmentLength - 4;
            this.fragmentLength = 0;
        } else {
            this.readBuffer(this.stream, this.buffer, this.buffer.length);
            this.bufferHighmark = this.buffer.length - 4;
            this.fragmentLength -= this.buffer.length;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endDecoding() throws OncRpcException, IOException {
        try {
            while (!this.lastFragment || this.fragmentLength != 0) {
                this.fill();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.bufferIndex = 0;
            this.bufferHighmark = -4;
            this.lastFragment = false;
            this.fragmentLength = 0;
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.bufferIndex = 0;
            this.bufferHighmark = -4;
            this.lastFragment = false;
            this.fragmentLength = 0;
            return;
        }
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.stream = null;
        this.socket = null;
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        while (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        int value = this.buffer[this.bufferIndex++] & 0xFF;
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        return value;
    }

    public byte[] xdrDecodeOpaque(int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        int offset = 0;
        byte[] bytes = new byte[length];
        while (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.bufferIndex + 4;
            if (toCopy >= length) {
                System.arraycopy(this.buffer, this.bufferIndex, bytes, offset, length);
                this.bufferIndex += length;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, bytes, offset, toCopy);
            this.bufferIndex += toCopy;
            offset += toCopy;
            length -= toCopy;
            this.fill();
        }
        this.bufferIndex += padding;
        return bytes;
    }

    public void xdrDecodeOpaque(byte[] opaque, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.bufferIndex + 4;
            if (toCopy >= length) {
                System.arraycopy(this.buffer, this.bufferIndex, opaque, offset, length);
                this.bufferIndex += length;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, opaque, offset, toCopy);
            this.bufferIndex += toCopy;
            offset += toCopy;
            length -= toCopy;
            this.fill();
        }
        this.bufferIndex += padding;
    }
}

