/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.client.impl.AccumuloServerException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.CompressedIterators;
import org.apache.accumulo.core.client.impl.DurabilityImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.TCMResult;
import org.apache.accumulo.core.data.thrift.TCMStatus;
import org.apache.accumulo.core.data.thrift.TCondition;
import org.apache.accumulo.core.data.thrift.TConditionalMutation;
import org.apache.accumulo.core.data.thrift.TConditionalSession;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TMutation;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.security.VisibilityParseException;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConditionalWriterImpl
implements ConditionalWriter {
    private static ThreadPoolExecutor cleanupThreadPool = new ThreadPoolExecutor(1, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new CleanupThreadFactory());
    private static final Logger log;
    private static final int MAX_SLEEP = 30000;
    private Authorizations auths;
    private VisibilityEvaluator ve;
    private Map<Text, Boolean> cache = Collections.synchronizedMap(new LRUMap(1000));
    private final ClientContext context;
    private TabletLocator locator;
    private String tableId;
    private long timeout;
    private final Durability durability;
    private Map<String, ServerQueue> serverQueues;
    private DelayQueue<QCMutation> failedMutations = new DelayQueue();
    private ScheduledThreadPoolExecutor threadPool;
    private HashMap<HostAndPort, SessionID> cachedSessionIDs = new HashMap();
    private static final ConditionComparator CONDITION_COMPARATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerQueue getServerQueue(String location) {
        ServerQueue serverQueue;
        Map<String, ServerQueue> map = this.serverQueues;
        synchronized (map) {
            serverQueue = this.serverQueues.get(location);
            if (serverQueue == null) {
                serverQueue = new ServerQueue();
                this.serverQueues.put(location, serverQueue);
            }
        }
        return serverQueue;
    }

    private void queueRetry(List<QCMutation> mutations, HostAndPort server) {
        if (this.timeout < Long.MAX_VALUE) {
            long time = System.currentTimeMillis();
            ArrayList<QCMutation> mutations2 = new ArrayList<QCMutation>(mutations.size());
            for (QCMutation qcm : mutations) {
                qcm.resetDelay();
                if (time + qcm.getDelay(TimeUnit.MILLISECONDS) > qcm.entryTime + this.timeout) {
                    TimedOutException toe = server != null ? new TimedOutException(Collections.singleton(server.toString())) : new TimedOutException("Conditional mutation timed out");
                    qcm.queueResult(new ConditionalWriter.Result(toe, (ConditionalMutation)qcm, null == server ? null : server.toString()));
                    continue;
                }
                mutations2.add(qcm);
            }
            if (mutations2.size() > 0) {
                this.failedMutations.addAll(mutations2);
            }
        } else {
            for (QCMutation qcm : mutations) {
                qcm.resetDelay();
            }
            this.failedMutations.addAll(mutations);
        }
    }

    private void queue(List<QCMutation> mutations) {
        ArrayList<QCMutation> failures = new ArrayList<QCMutation>();
        HashMap binnedMutations = new HashMap();
        try {
            this.locator.binMutations(this.context, mutations, binnedMutations, failures);
            if (failures.size() == mutations.size()) {
                if (!Tables.exists(this.context.getInstance(), this.tableId)) {
                    throw new TableDeletedException(this.tableId);
                }
                if (Tables.getTableState(this.context.getInstance(), this.tableId) == TableState.OFFLINE) {
                    throw new TableOfflineException(this.context.getInstance(), this.tableId);
                }
            }
        }
        catch (Exception e) {
            for (QCMutation qcm : mutations) {
                qcm.queueResult(new ConditionalWriter.Result(e, (ConditionalMutation)qcm, null));
            }
            failures.clear();
            binnedMutations.clear();
        }
        if (failures.size() > 0) {
            this.queueRetry(failures, null);
        }
        for (Map.Entry entry : binnedMutations.entrySet()) {
            this.queue((String)entry.getKey(), (TabletLocator.TabletServerMutations)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(String location, TabletLocator.TabletServerMutations<QCMutation> mutations) {
        ServerQueue serverQueue;
        ServerQueue serverQueue2 = serverQueue = this.getServerQueue(location);
        synchronized (serverQueue2) {
            serverQueue.queue.add(mutations);
            if (!serverQueue.taskQueued) {
                this.threadPool.execute((Runnable)new LoggingRunnable(log, Trace.wrap(new SendTask(location))));
                serverQueue.taskQueued = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reschedule(SendTask task) {
        ServerQueue serverQueue;
        ServerQueue serverQueue2 = serverQueue = this.getServerQueue(task.location);
        synchronized (serverQueue2) {
            if (serverQueue.queue.size() > 0) {
                this.threadPool.execute((Runnable)new LoggingRunnable(log, Trace.wrap(task)));
            } else {
                serverQueue.taskQueued = false;
            }
        }
    }

    private TabletLocator.TabletServerMutations<QCMutation> dequeue(String location) {
        BlockingQueue<TabletLocator.TabletServerMutations<QCMutation>> queue = this.getServerQueue((String)location).queue;
        ArrayList mutations = new ArrayList();
        queue.drainTo(mutations);
        if (mutations.size() == 0) {
            return null;
        }
        if (mutations.size() == 1) {
            return (TabletLocator.TabletServerMutations)mutations.get(0);
        }
        TabletLocator.TabletServerMutations tsm = (TabletLocator.TabletServerMutations)mutations.get(0);
        for (int i = 1; i < mutations.size(); ++i) {
            for (Map.Entry entry : ((TabletLocator.TabletServerMutations)mutations.get(i)).getMutations().entrySet()) {
                List list = tsm.getMutations().get(entry.getKey());
                if (list == null) {
                    list = new ArrayList();
                    tsm.getMutations().put(entry.getKey(), list);
                }
                list.addAll(entry.getValue());
            }
        }
        return tsm;
    }

    ConditionalWriterImpl(ClientContext context, String tableId, ConditionalWriterConfig config) {
        this.context = context;
        this.auths = config.getAuthorizations();
        this.ve = new VisibilityEvaluator(config.getAuthorizations());
        this.threadPool = new ScheduledThreadPoolExecutor(config.getMaxWriteThreads(), new NamingThreadFactory(this.getClass().getSimpleName()));
        this.locator = TabletLocator.getLocator(context, new Text(tableId));
        this.serverQueues = new HashMap<String, ServerQueue>();
        this.tableId = tableId;
        this.timeout = config.getTimeout(TimeUnit.MILLISECONDS);
        this.durability = config.getDurability();
        Runnable failureHandler = new Runnable(){

            @Override
            public void run() {
                ArrayList mutations = new ArrayList();
                ConditionalWriterImpl.this.failedMutations.drainTo(mutations);
                if (mutations.size() > 0) {
                    ConditionalWriterImpl.this.queue(mutations);
                }
            }
        };
        failureHandler = new LoggingRunnable(log, failureHandler);
        this.threadPool.scheduleAtFixedRate(failureHandler, 250L, 250L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Iterator<ConditionalWriter.Result> write(Iterator<ConditionalMutation> mutations) {
        LinkedBlockingQueue<ConditionalWriter.Result> resultQueue = new LinkedBlockingQueue<ConditionalWriter.Result>();
        ArrayList<QCMutation> mutationList = new ArrayList<QCMutation>();
        int count = 0;
        long entryTime = System.currentTimeMillis();
        block0: while (mutations.hasNext()) {
            ConditionalMutation mut = mutations.next();
            ++count;
            if (mut.getConditions().size() == 0) {
                throw new IllegalArgumentException("ConditionalMutation had no conditions " + new String(mut.getRow(), StandardCharsets.UTF_8));
            }
            for (Condition cond : mut.getConditions()) {
                if (this.isVisible(cond.getVisibility())) continue;
                resultQueue.add(new ConditionalWriter.Result(ConditionalWriter.Status.INVISIBLE_VISIBILITY, mut, null));
                continue block0;
            }
            mutationList.add(new QCMutation(mut, resultQueue, entryTime));
        }
        this.queue(mutationList);
        return new RQIterator(resultQueue, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionID reserveSessionID(HostAndPort location, TabletClientService.Iface client, TInfo tinfo) throws ThriftSecurityException, TException {
        HashMap<HostAndPort, SessionID> hashMap = this.cachedSessionIDs;
        synchronized (hashMap) {
            SessionID sid = this.cachedSessionIDs.get(location);
            if (sid != null) {
                if (sid.reserved) {
                    throw new IllegalStateException();
                }
                if (!sid.isActive()) {
                    this.cachedSessionIDs.remove(location);
                } else {
                    sid.reserved = true;
                    return sid;
                }
            }
        }
        TConditionalSession tcs = client.startConditionalUpdate(tinfo, this.context.rpcCreds(), ByteBufferUtil.toByteBuffers(this.auths.getAuthorizations()), this.tableId, DurabilityImpl.toThrift(this.durability));
        HashMap<HostAndPort, SessionID> hashMap2 = this.cachedSessionIDs;
        synchronized (hashMap2) {
            SessionID sid = new SessionID();
            sid.reserved = true;
            sid.sessionID = tcs.sessionId;
            sid.lockId = tcs.tserverLock;
            sid.ttl = tcs.ttl;
            sid.location = location;
            if (this.cachedSessionIDs.put(location, sid) != null) {
                throw new IllegalStateException();
            }
            return sid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSessionID(HostAndPort location) {
        HashMap<HostAndPort, SessionID> hashMap = this.cachedSessionIDs;
        synchronized (hashMap) {
            this.cachedSessionIDs.remove(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserveSessionID(HostAndPort location) {
        HashMap<HostAndPort, SessionID> hashMap = this.cachedSessionIDs;
        synchronized (hashMap) {
            SessionID sid = this.cachedSessionIDs.get(location);
            if (sid != null) {
                if (!sid.reserved) {
                    throw new IllegalStateException();
                }
                sid.reserved = false;
                sid.lastAccessTime = System.currentTimeMillis();
            }
        }
    }

    List<SessionID> getActiveSessions() {
        ArrayList<SessionID> activeSessions = new ArrayList<SessionID>();
        for (SessionID sid : this.cachedSessionIDs.values()) {
            if (!sid.isActive()) continue;
            activeSessions.add(sid);
        }
        return activeSessions;
    }

    private TabletClientService.Iface getClient(HostAndPort location) throws TTransportException {
        TabletClientService.Client client = this.timeout < this.context.getClientTimeoutInMillis() ? ThriftUtil.getTServerClient(location, this.context, this.timeout) : ThriftUtil.getTServerClient(location, this.context);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToServer(HostAndPort location, TabletLocator.TabletServerMutations<QCMutation> mutations) {
        TabletClientService.Iface client = null;
        TInfo tinfo = Tracer.traceInfo();
        HashMap<Long, CMK> cmidToCm = new HashMap<Long, CMK>();
        MutableLong cmid = new MutableLong(0L);
        SessionID sessionId = null;
        try {
            HashMap<TKeyExtent, List<TConditionalMutation>> tmutations = new HashMap<TKeyExtent, List<TConditionalMutation>>();
            CompressedIterators compressedIters = new CompressedIterators();
            this.convertMutations(mutations, cmidToCm, cmid, tmutations, compressedIters);
            client = this.getClient(location);
            List<TCMResult> tresults = null;
            while (tresults == null) {
                try {
                    sessionId = this.reserveSessionID(location, client, tinfo);
                    tresults = client.conditionalUpdate(tinfo, sessionId.sessionID, tmutations, compressedIters.getSymbolTable());
                }
                catch (NoSuchScanIDException nssie) {
                    sessionId = null;
                    this.invalidateSessionID(location);
                }
            }
            HashSet<KeyExtent> extentsToInvalidate = new HashSet<KeyExtent>();
            ArrayList<QCMutation> ignored = new ArrayList<QCMutation>();
            for (TCMResult tcmResult : tresults) {
                if (tcmResult.status == TCMStatus.IGNORED) {
                    CMK cmk = (CMK)cmidToCm.get(tcmResult.cmid);
                    ignored.add(cmk.cm);
                    extentsToInvalidate.add(cmk.ke);
                    continue;
                }
                QCMutation qcm = ((CMK)cmidToCm.get((Object)Long.valueOf((long)tcmResult.cmid))).cm;
                qcm.queueResult(new ConditionalWriter.Result(this.fromThrift(tcmResult.status), (ConditionalMutation)qcm, location.toString()));
            }
            for (KeyExtent ke : extentsToInvalidate) {
                this.locator.invalidateCache(ke);
            }
            this.queueRetry(ignored, location);
        }
        catch (ThriftSecurityException tse) {
            AccumuloSecurityException ase = new AccumuloSecurityException(this.context.getCredentials().getPrincipal(), tse.getCode(), Tables.getPrintableTableInfoFromId(this.context.getInstance(), this.tableId), (Throwable)((Object)tse));
            this.queueException(location, cmidToCm, ase);
        }
        catch (TTransportException e) {
            this.locator.invalidateCache(this.context.getInstance(), location.toString());
            this.invalidateSession(location, mutations, cmidToCm, sessionId);
        }
        catch (TApplicationException tae) {
            this.queueException(location, cmidToCm, new AccumuloServerException(location.toString(), tae));
        }
        catch (TException e) {
            this.locator.invalidateCache(this.context.getInstance(), location.toString());
            this.invalidateSession(location, mutations, cmidToCm, sessionId);
        }
        catch (Exception e) {
            this.queueException(location, cmidToCm, e);
        }
        finally {
            if (sessionId != null) {
                this.unreserveSessionID(location);
            }
            ThriftUtil.returnClient((TServiceClient)client);
        }
    }

    private void queueRetry(Map<Long, CMK> cmidToCm, HostAndPort location) {
        ArrayList<QCMutation> ignored = new ArrayList<QCMutation>();
        for (CMK cmk : cmidToCm.values()) {
            ignored.add(cmk.cm);
        }
        this.queueRetry(ignored, location);
    }

    private void queueException(HostAndPort location, Map<Long, CMK> cmidToCm, Exception e) {
        for (CMK cmk : cmidToCm.values()) {
            cmk.cm.queueResult(new ConditionalWriter.Result(e, (ConditionalMutation)cmk.cm, location.toString()));
        }
    }

    private void invalidateSession(HostAndPort location, TabletLocator.TabletServerMutations<QCMutation> mutations, Map<Long, CMK> cmidToCm, SessionID sessionId) {
        if (sessionId == null) {
            this.queueRetry(cmidToCm, location);
        } else {
            try {
                this.invalidateSession(sessionId, location);
                for (CMK cmk : cmidToCm.values()) {
                    cmk.cm.queueResult(new ConditionalWriter.Result(ConditionalWriter.Status.UNKNOWN, (ConditionalMutation)cmk.cm, location.toString()));
                }
            }
            catch (Exception e2) {
                this.queueException(location, cmidToCm, e2);
            }
        }
    }

    private void invalidateSession(SessionID sessionId, HostAndPort location) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        long sleepTime = 50L;
        long startTime = System.currentTimeMillis();
        Instance instance = this.context.getInstance();
        ZooUtil.LockID lid = new ZooUtil.LockID(ZooUtil.getRoot(instance) + "/tservers", sessionId.lockId);
        ZooCacheFactory zcf = new ZooCacheFactory();
        while (true) {
            if (!ZooLock.isLockHeld((ZooCache)zcf.getZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut()), (ZooUtil.LockID)lid)) {
                this.locator.invalidateCache(this.context.getInstance(), location.toString());
                return;
            }
            try {
                this.invalidateSession(sessionId.sessionID, location);
                return;
            }
            catch (TApplicationException tae) {
                throw new AccumuloServerException(location.toString(), tae);
            }
            catch (TException e) {
                this.locator.invalidateCache(this.context.getInstance(), location.toString());
                if (System.currentTimeMillis() - startTime + sleepTime > this.timeout) {
                    throw new TimedOutException(Collections.singleton(location.toString()));
                }
                UtilWaitThread.sleep(sleepTime);
                sleepTime = Math.min(2L * sleepTime, 30000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSession(long sessionId, HostAndPort location) throws TException {
        TabletClientService.Iface client = null;
        TInfo tinfo = Tracer.traceInfo();
        try {
            client = this.getClient(location);
            client.invalidateConditionalUpdate(tinfo, sessionId);
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client);
        }
    }

    private ConditionalWriter.Status fromThrift(TCMStatus status) {
        switch (status) {
            case ACCEPTED: {
                return ConditionalWriter.Status.ACCEPTED;
            }
            case REJECTED: {
                return ConditionalWriter.Status.REJECTED;
            }
            case VIOLATED: {
                return ConditionalWriter.Status.VIOLATED;
            }
        }
        throw new IllegalArgumentException(status.toString());
    }

    private void convertMutations(TabletLocator.TabletServerMutations<QCMutation> mutations, Map<Long, CMK> cmidToCm, MutableLong cmid, Map<TKeyExtent, List<TConditionalMutation>> tmutations, CompressedIterators compressedIters) {
        for (Map.Entry<KeyExtent, List<QCMutation>> entry : mutations.getMutations().entrySet()) {
            TKeyExtent tke = entry.getKey().toThrift();
            ArrayList<TConditionalMutation> tcondMutaions = new ArrayList<TConditionalMutation>();
            List<QCMutation> condMutations = entry.getValue();
            for (QCMutation cm : condMutations) {
                TMutation tm = cm.toThrift();
                List<TCondition> conditions = this.convertConditions(cm, compressedIters);
                cmidToCm.put(cmid.longValue(), new CMK(entry.getKey(), cm));
                TConditionalMutation tcm = new TConditionalMutation(conditions, tm, cmid.longValue());
                cmid.increment();
                tcondMutaions.add(tcm);
            }
            tmutations.put(tke, tcondMutaions);
        }
    }

    private List<TCondition> convertConditions(ConditionalMutation cm, CompressedIterators compressedIters) {
        ArrayList<TCondition> conditions = new ArrayList<TCondition>(cm.getConditions().size());
        Condition[] ca = cm.getConditions().toArray(new Condition[cm.getConditions().size()]);
        Arrays.sort(ca, CONDITION_COMPARATOR);
        for (Condition cond : ca) {
            long ts = 0L;
            boolean hasTs = false;
            if (cond.getTimestamp() != null) {
                ts = cond.getTimestamp();
                hasTs = true;
            }
            ByteBuffer iters = compressedIters.compress(cond.getIterators());
            TCondition tc = new TCondition(ByteBufferUtil.toByteBuffers(cond.getFamily()), ByteBufferUtil.toByteBuffers(cond.getQualifier()), ByteBufferUtil.toByteBuffers(cond.getVisibility()), ts, hasTs, ByteBufferUtil.toByteBuffers(cond.getValue()), iters);
            conditions.add(tc);
        }
        return conditions;
    }

    private boolean isVisible(ByteSequence cv) {
        Text testVis = new Text(cv.toArray());
        if (testVis.getLength() == 0) {
            return true;
        }
        Boolean b = this.cache.get(testVis);
        if (b != null) {
            return b;
        }
        try {
            Boolean bb = this.ve.evaluate(new ColumnVisibility(testVis));
            this.cache.put(new Text(testVis), bb);
            return bb;
        }
        catch (VisibilityParseException e) {
            return false;
        }
        catch (BadArgumentException e) {
            return false;
        }
    }

    @Override
    public ConditionalWriter.Result write(ConditionalMutation mutation) {
        return this.write(Collections.singleton(mutation).iterator()).next();
    }

    @Override
    public void close() {
        this.threadPool.shutdownNow();
        cleanupThreadPool.execute(new CleanupTask(this.getActiveSessions()));
    }

    static {
        cleanupThreadPool.allowCoreThreadTimeOut(true);
        log = LoggerFactory.getLogger(ConditionalWriterImpl.class);
        CONDITION_COMPARATOR = new ConditionComparator();
    }

    static class ConditionComparator
    implements Comparator<Condition> {
        private static final Long MAX = Long.MAX_VALUE;

        ConditionComparator() {
        }

        @Override
        public int compare(Condition c1, Condition c2) {
            int comp = c1.getFamily().compareTo(c2.getFamily());
            if (comp == 0 && (comp = c1.getQualifier().compareTo(c2.getQualifier())) == 0 && (comp = c1.getVisibility().compareTo(c2.getVisibility())) == 0) {
                Long l1 = c1.getTimestamp();
                Long l2 = c2.getTimestamp();
                if (l1 == null) {
                    l1 = MAX;
                }
                if (l2 == null) {
                    l2 = MAX;
                }
                comp = l2.compareTo(l1);
            }
            return comp;
        }
    }

    private static class SessionID {
        HostAndPort location;
        String lockId;
        long sessionID;
        boolean reserved;
        long lastAccessTime;
        long ttl;

        private SessionID() {
        }

        boolean isActive() {
            return (double)(System.currentTimeMillis() - this.lastAccessTime) < (double)this.ttl * 0.95;
        }
    }

    private static class CMK {
        QCMutation cm;
        KeyExtent ke;

        public CMK(KeyExtent ke, QCMutation cm) {
            this.ke = ke;
            this.cm = cm;
        }
    }

    private class SendTask
    implements Runnable {
        String location;

        public SendTask(String location) {
            this.location = location;
        }

        @Override
        public void run() {
            try {
                TabletLocator.TabletServerMutations mutations = ConditionalWriterImpl.this.dequeue(this.location);
                if (mutations != null) {
                    ConditionalWriterImpl.this.sendToServer(HostAndPort.fromString(this.location), mutations);
                }
            }
            finally {
                ConditionalWriterImpl.this.reschedule(this);
            }
        }
    }

    private class CleanupTask
    implements Runnable {
        private List<SessionID> sessions;

        CleanupTask(List<SessionID> activeSessions) {
            this.sessions = activeSessions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TabletClientService.Iface client = null;
            for (SessionID sid : this.sessions) {
                if (!sid.isActive()) continue;
                TInfo tinfo = Tracer.traceInfo();
                try {
                    client = ConditionalWriterImpl.this.getClient(sid.location);
                    client.closeConditionalUpdate(tinfo, sid.sessionID);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    ThriftUtil.returnClient((TServiceClient)client);
                }
            }
        }
    }

    private static class QCMutation
    extends ConditionalMutation
    implements Delayed {
        private BlockingQueue<ConditionalWriter.Result> resultQueue;
        private long resetTime;
        private long delay = 50L;
        private long entryTime;

        QCMutation(ConditionalMutation cm, BlockingQueue<ConditionalWriter.Result> resultQueue, long entryTime) {
            super(cm);
            this.resultQueue = resultQueue;
            this.entryTime = entryTime;
        }

        @Override
        public int compareTo(Delayed o) {
            QCMutation oqcm = (QCMutation)o;
            return Long.compare(this.resetTime, oqcm.resetTime);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof QCMutation) {
                return this.compareTo((QCMutation)o) == 0;
            }
            return false;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.delay - (System.currentTimeMillis() - this.resetTime), TimeUnit.MILLISECONDS);
        }

        void resetDelay() {
            this.delay = Math.min(this.delay * 2L, 30000L);
            this.resetTime = System.currentTimeMillis();
        }

        void queueResult(ConditionalWriter.Result result) {
            this.resultQueue.add(result);
        }
    }

    private class RQIterator
    implements Iterator<ConditionalWriter.Result> {
        private BlockingQueue<ConditionalWriter.Result> rq;
        private int count;

        public RQIterator(BlockingQueue<ConditionalWriter.Result> resultQueue, int count) {
            this.rq = resultQueue;
            this.count = count;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public ConditionalWriter.Result next() {
            if (this.count <= 0) {
                throw new NoSuchElementException();
            }
            try {
                ConditionalWriter.Result result = this.rq.poll(1L, TimeUnit.SECONDS);
                while (result == null) {
                    if (ConditionalWriterImpl.this.threadPool.isShutdown()) {
                        throw new NoSuchElementException("ConditionalWriter closed");
                    }
                    result = this.rq.poll(1L, TimeUnit.SECONDS);
                }
                --this.count;
                return result;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ServerQueue {
        BlockingQueue<TabletLocator.TabletServerMutations<QCMutation>> queue = new LinkedBlockingQueue<TabletLocator.TabletServerMutations<QCMutation>>();
        boolean taskQueued = false;

        private ServerQueue() {
        }
    }

    private static class CleanupThreadFactory
    implements ThreadFactory {
        private CleanupThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Conditional Writer Cleanup Thread ");
            t.setDaemon(true);
            return t;
        }
    }
}

