/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ScannerIterator;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

public class ScannerImpl
extends ScannerOptions
implements Scanner {
    private final ClientContext context;
    private Authorizations authorizations;
    private Text table;
    private int size;
    private Range range;
    private boolean isolated = false;
    private long readaheadThreshold = 3L;

    public ScannerImpl(ClientContext context, String table, Authorizations authorizations) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.context = context;
        this.table = new Text(table);
        this.range = new Range((Key)null, (Key)null);
        this.authorizations = authorizations;
        this.size = 1000;
    }

    @Override
    public synchronized void setRange(Range range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"range is null");
        this.range = range;
    }

    @Override
    public synchronized Range getRange() {
        return this.range;
    }

    @Override
    public synchronized void setBatchSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be greater than zero");
        }
        this.size = size;
    }

    @Override
    public synchronized int getBatchSize() {
        return this.size;
    }

    @Override
    public synchronized Iterator<Map.Entry<Key, Value>> iterator() {
        return new ScannerIterator(this.context, this.table, this.authorizations, this.range, this.size, this.getTimeOut(), this, this.isolated, this.readaheadThreshold);
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public synchronized void enableIsolation() {
        this.isolated = true;
    }

    @Override
    public synchronized void disableIsolation() {
        this.isolated = false;
    }

    @Override
    @Deprecated
    public void setTimeOut(int timeOut) {
        if (timeOut == Integer.MAX_VALUE) {
            this.setTimeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        } else {
            this.setTimeout(timeOut, TimeUnit.SECONDS);
        }
    }

    @Override
    @Deprecated
    public int getTimeOut() {
        long timeout = this.getTimeout(TimeUnit.SECONDS);
        if (timeout >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeout;
    }

    @Override
    public synchronized void setReadaheadThreshold(long batches) {
        if (0L > batches) {
            throw new IllegalArgumentException("Number of batches before read-ahead must be non-negative");
        }
        this.readaheadThreshold = batches;
    }

    @Override
    public synchronized long getReadaheadThreshold() {
        return this.readaheadThreshold;
    }
}

