/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.ThriftTransportKey;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerClient {
    private static final Logger log = LoggerFactory.getLogger(ServerClient.class);
    static volatile boolean warnedAboutTServersBeingDown = false;

    public static <T> T execute(ClientContext context, ClientExecReturn<T, ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            return ServerClient.executeRaw(context, exec);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    public static void execute(ClientContext context, ClientExec<ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            ServerClient.executeRaw(context, exec);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeRaw(ClientContext context, ClientExecReturn<T, ClientService.Client> exec) throws Exception {
        while (true) {
            T t;
            block6: {
                ClientService.Client client = null;
                String server = null;
                try {
                    Pair<String, ClientService.Client> pair = ServerClient.getConnection(context);
                    server = pair.getFirst();
                    client = pair.getSecond();
                    t = exec.execute(client);
                    if (client == null) break block6;
                }
                catch (TTransportException tte) {
                    try {
                        log.debug("ClientService request failed " + server + ", retrying ... ", (Throwable)tte);
                        UtilWaitThread.sleep(100L);
                        if (client == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            ServerClient.close(client);
                        }
                        throw throwable;
                    }
                    ServerClient.close(client);
                    continue;
                }
                ServerClient.close(client);
            }
            return t;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeRaw(ClientContext context, ClientExec<ClientService.Client> exec) throws Exception {
        while (true) {
            ClientService.Client client = null;
            String server = null;
            try {
                Pair<String, ClientService.Client> pair = ServerClient.getConnection(context);
                server = pair.getFirst();
                client = pair.getSecond();
                exec.execute(client);
                if (client == null) break;
            }
            catch (TTransportException tte) {
                try {
                    log.debug("ClientService request failed " + server + ", retrying ... ", (Throwable)tte);
                    UtilWaitThread.sleep(100L);
                    if (client == null) continue;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        ServerClient.close(client);
                    }
                    throw throwable;
                }
                ServerClient.close(client);
                continue;
            }
            ServerClient.close(client);
            break;
        }
    }

    public static Pair<String, ClientService.Client> getConnection(ClientContext context) throws TTransportException {
        return ServerClient.getConnection(context, true);
    }

    public static Pair<String, ClientService.Client> getConnection(ClientContext context, boolean preferCachedConnections) throws TTransportException {
        return ServerClient.getConnection(context, preferCachedConnections, context.getClientTimeoutInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, ClientService.Client> getConnection(ClientContext context, boolean preferCachedConnections, long rpcTimeout) throws TTransportException {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        ArrayList<ThriftTransportKey> servers = new ArrayList<ThriftTransportKey>();
        Instance instance = context.getInstance();
        ZooCache zc = new ZooCacheFactory().getZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
        for (String tserver : zc.getChildren(ZooUtil.getRoot(instance) + "/tservers")) {
            String strData;
            String path = ZooUtil.getRoot(instance) + "/tservers" + "/" + tserver;
            byte[] data = ZooUtil.getLockData((ZooCache)zc, (String)path);
            if (data == null || (strData = new String(data, StandardCharsets.UTF_8)).equals("master")) continue;
            servers.add(new ThriftTransportKey(new ServerServices(strData).getAddress(ServerServices.Service.TSERV_CLIENT), rpcTimeout, context));
        }
        boolean opened = false;
        try {
            Pair<String, TTransport> pair = ThriftTransportPool.getInstance().getAnyTransport(servers, preferCachedConnections);
            ClientService.Client client = ThriftUtil.createClient(new ClientService.Client.Factory(), pair.getSecond());
            opened = true;
            warnedAboutTServersBeingDown = false;
            Pair<String, ClientService.Client> pair2 = new Pair<String, ClientService.Client>(pair.getFirst(), client);
            return pair2;
        }
        finally {
            if (!opened && !warnedAboutTServersBeingDown) {
                if (servers.isEmpty()) {
                    log.warn("There are no tablet servers: check that zookeeper and accumulo are running.");
                } else {
                    log.warn("Failed to find an available server in the list of servers: " + servers);
                }
                warnedAboutTServersBeingDown = true;
            }
        }
    }

    public static void close(ClientService.Client client) {
        if (client != null && client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
            ThriftTransportPool.getInstance().returnTransport(client.getInputProtocol().getTransport());
        } else {
            log.debug("Attempt to close null connection to a server", (Throwable)new Exception());
        }
    }
}

