/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.CredentialProviderFactoryShim;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteConfiguration
extends AccumuloConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SiteConfiguration.class);
    private static final AccumuloConfiguration parent = DefaultConfiguration.getInstance();
    private static SiteConfiguration instance = null;
    private static Configuration xmlConfig;
    private final Map<String, String> staticConfigs;

    private SiteConfiguration() {
        Configuration conf = SiteConfiguration.getXmlConfig();
        HashMap temp = new HashMap((int)Math.ceil((float)conf.size() / 0.75f), 0.75f);
        for (Map.Entry entry : conf) {
            temp.put(entry.getKey(), entry.getValue());
        }
        for (Property hotConfig : Property.HOT_PATH_PROPERTIES) {
            if (temp.containsKey(hotConfig.getKey())) continue;
            temp.put(hotConfig.getKey(), null);
        }
        this.staticConfigs = Collections.unmodifiableMap(temp);
    }

    public static synchronized SiteConfiguration getInstance() {
        if (instance == null) {
            instance = new SiteConfiguration();
            ConfigSanityCheck.validate(instance);
        }
        return instance;
    }

    private static synchronized Configuration getXmlConfig() {
        String configFile = System.getProperty("org.apache.accumulo.config.file", "accumulo-site.xml");
        if (xmlConfig == null) {
            xmlConfig = new Configuration(false);
            if (SiteConfiguration.class.getClassLoader().getResource(configFile) == null) {
                log.warn(configFile + " not found on classpath", new Throwable());
            } else {
                xmlConfig.addResource(configFile);
            }
        }
        return xmlConfig;
    }

    @Override
    public String get(Property property) {
        String value;
        Configuration hadoopConf;
        String key = property.getKey();
        if (property.isSensitive() && null != (hadoopConf = this.getHadoopConfiguration())) {
            try {
                char[] value2 = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key);
                if (null != value2) {
                    return new String(value2);
                }
            }
            catch (IOException e) {
                log.warn("Failed to extract sensitive property (" + key + ") from Hadoop CredentialProvider, falling back to accumulo-site.xml", (Throwable)e);
            }
        }
        String string = value = this.staticConfigs.containsKey(key) ? this.staticConfigs.get(key) : SiteConfiguration.getXmlConfig().get(key);
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error("Using default value for " + key + " due to improperly formatted " + (Object)((Object)property.getType()) + ": " + value);
            }
            value = parent.get(property);
        }
        return value;
    }

    @Override
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        parent.getProperties(props, filter);
        for (Object entry : SiteConfiguration.getXmlConfig()) {
            if (!filter.apply(entry.getKey())) continue;
            props.put((String)entry.getKey(), (String)entry.getValue());
        }
        Configuration hadoopConf = this.getHadoopConfiguration();
        if (null != hadoopConf) {
            try {
                for (String key : CredentialProviderFactoryShim.getKeys(hadoopConf)) {
                    char[] value;
                    if (!Property.isValidPropertyKey(key) || !Property.isSensitive(key) || !filter.apply((Object)key) || null == (value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key))) continue;
                    props.put(key, new String(value));
                }
            }
            catch (IOException e) {
                log.warn("Failed to extract sensitive properties from Hadoop CredentialProvider, falling back to accumulo-site.xml", (Throwable)e);
            }
        }
    }

    protected Configuration getHadoopConfiguration() {
        String credProviderPathsKey = Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey();
        String credProviderPathsValue = SiteConfiguration.getXmlConfig().get(credProviderPathsKey);
        if (null != credProviderPathsValue) {
            Configuration conf = new Configuration(CachedConfiguration.getInstance());
            conf.set("hadoop.security.credential.provider.path", credProviderPathsValue);
            return conf;
        }
        return null;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public void set(Property property, String value) {
        this.set(property.getKey(), value);
    }

    public void set(String key, String value) {
        SiteConfiguration.getXmlConfig().set(key, value);
    }
}

