/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TKeyExtent
implements TBase<TKeyExtent, _Fields>,
Serializable,
Cloneable,
Comparable<TKeyExtent> {
    private static final TStruct STRUCT_DESC = new TStruct("TKeyExtent");
    private static final TField TABLE_FIELD_DESC = new TField("table", 11, 1);
    private static final TField END_ROW_FIELD_DESC = new TField("endRow", 11, 2);
    private static final TField PREV_END_ROW_FIELD_DESC = new TField("prevEndRow", 11, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer table;
    public ByteBuffer endRow;
    public ByteBuffer prevEndRow;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TKeyExtent() {
    }

    public TKeyExtent(ByteBuffer table, ByteBuffer endRow, ByteBuffer prevEndRow) {
        this();
        this.table = table;
        this.endRow = endRow;
        this.prevEndRow = prevEndRow;
    }

    public TKeyExtent(TKeyExtent other) {
        if (other.isSetTable()) {
            this.table = TBaseHelper.copyBinary((ByteBuffer)other.table);
        }
        if (other.isSetEndRow()) {
            this.endRow = TBaseHelper.copyBinary((ByteBuffer)other.endRow);
        }
        if (other.isSetPrevEndRow()) {
            this.prevEndRow = TBaseHelper.copyBinary((ByteBuffer)other.prevEndRow);
        }
    }

    public TKeyExtent deepCopy() {
        return new TKeyExtent(this);
    }

    public void clear() {
        this.table = null;
        this.endRow = null;
        this.prevEndRow = null;
    }

    public byte[] getTable() {
        this.setTable(TBaseHelper.rightSize((ByteBuffer)this.table));
        return this.table == null ? null : this.table.array();
    }

    public ByteBuffer bufferForTable() {
        return this.table;
    }

    public TKeyExtent setTable(byte[] table) {
        this.setTable(table == null ? (ByteBuffer)null : ByteBuffer.wrap(table));
        return this;
    }

    public TKeyExtent setTable(ByteBuffer table) {
        this.table = table;
        return this;
    }

    public void unsetTable() {
        this.table = null;
    }

    public boolean isSetTable() {
        return this.table != null;
    }

    public void setTableIsSet(boolean value) {
        if (!value) {
            this.table = null;
        }
    }

    public byte[] getEndRow() {
        this.setEndRow(TBaseHelper.rightSize((ByteBuffer)this.endRow));
        return this.endRow == null ? null : this.endRow.array();
    }

    public ByteBuffer bufferForEndRow() {
        return this.endRow;
    }

    public TKeyExtent setEndRow(byte[] endRow) {
        this.setEndRow(endRow == null ? (ByteBuffer)null : ByteBuffer.wrap(endRow));
        return this;
    }

    public TKeyExtent setEndRow(ByteBuffer endRow) {
        this.endRow = endRow;
        return this;
    }

    public void unsetEndRow() {
        this.endRow = null;
    }

    public boolean isSetEndRow() {
        return this.endRow != null;
    }

    public void setEndRowIsSet(boolean value) {
        if (!value) {
            this.endRow = null;
        }
    }

    public byte[] getPrevEndRow() {
        this.setPrevEndRow(TBaseHelper.rightSize((ByteBuffer)this.prevEndRow));
        return this.prevEndRow == null ? null : this.prevEndRow.array();
    }

    public ByteBuffer bufferForPrevEndRow() {
        return this.prevEndRow;
    }

    public TKeyExtent setPrevEndRow(byte[] prevEndRow) {
        this.setPrevEndRow(prevEndRow == null ? (ByteBuffer)null : ByteBuffer.wrap(prevEndRow));
        return this;
    }

    public TKeyExtent setPrevEndRow(ByteBuffer prevEndRow) {
        this.prevEndRow = prevEndRow;
        return this;
    }

    public void unsetPrevEndRow() {
        this.prevEndRow = null;
    }

    public boolean isSetPrevEndRow() {
        return this.prevEndRow != null;
    }

    public void setPrevEndRowIsSet(boolean value) {
        if (!value) {
            this.prevEndRow = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TABLE: {
                if (value == null) {
                    this.unsetTable();
                    break;
                }
                this.setTable((ByteBuffer)value);
                break;
            }
            case END_ROW: {
                if (value == null) {
                    this.unsetEndRow();
                    break;
                }
                this.setEndRow((ByteBuffer)value);
                break;
            }
            case PREV_END_ROW: {
                if (value == null) {
                    this.unsetPrevEndRow();
                    break;
                }
                this.setPrevEndRow((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE: {
                return this.getTable();
            }
            case END_ROW: {
                return this.getEndRow();
            }
            case PREV_END_ROW: {
                return this.getPrevEndRow();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE: {
                return this.isSetTable();
            }
            case END_ROW: {
                return this.isSetEndRow();
            }
            case PREV_END_ROW: {
                return this.isSetPrevEndRow();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TKeyExtent) {
            return this.equals((TKeyExtent)that);
        }
        return false;
    }

    public boolean equals(TKeyExtent that) {
        if (that == null) {
            return false;
        }
        boolean this_present_table = this.isSetTable();
        boolean that_present_table = that.isSetTable();
        if (this_present_table || that_present_table) {
            if (!this_present_table || !that_present_table) {
                return false;
            }
            if (!this.table.equals(that.table)) {
                return false;
            }
        }
        boolean this_present_endRow = this.isSetEndRow();
        boolean that_present_endRow = that.isSetEndRow();
        if (this_present_endRow || that_present_endRow) {
            if (!this_present_endRow || !that_present_endRow) {
                return false;
            }
            if (!this.endRow.equals(that.endRow)) {
                return false;
            }
        }
        boolean this_present_prevEndRow = this.isSetPrevEndRow();
        boolean that_present_prevEndRow = that.isSetPrevEndRow();
        if (this_present_prevEndRow || that_present_prevEndRow) {
            if (!this_present_prevEndRow || !that_present_prevEndRow) {
                return false;
            }
            if (!this.prevEndRow.equals(that.prevEndRow)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(TKeyExtent other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTable()).compareTo(other.isSetTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable() && (lastComparison = TBaseHelper.compareTo((Comparable)this.table, (Comparable)other.table)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEndRow()).compareTo(other.isSetEndRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEndRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.endRow, (Comparable)other.endRow)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPrevEndRow()).compareTo(other.isSetPrevEndRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrevEndRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.prevEndRow, (Comparable)other.prevEndRow)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TKeyExtent(");
        boolean first = true;
        sb.append("table:");
        if (this.table == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.table, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("endRow:");
        if (this.endRow == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.endRow, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("prevEndRow:");
        if (this.prevEndRow == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.prevEndRow, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TKeyExtentStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TKeyExtentTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE, new FieldMetaData("table", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.END_ROW, new FieldMetaData("endRow", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.PREV_END_ROW, new FieldMetaData("prevEndRow", 3, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TKeyExtent.class, metaDataMap);
    }

    private static class TKeyExtentTupleScheme
    extends TupleScheme<TKeyExtent> {
        private TKeyExtentTupleScheme() {
        }

        public void write(TProtocol prot, TKeyExtent struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTable()) {
                optionals.set(0);
            }
            if (struct.isSetEndRow()) {
                optionals.set(1);
            }
            if (struct.isSetPrevEndRow()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetTable()) {
                oprot.writeBinary(struct.table);
            }
            if (struct.isSetEndRow()) {
                oprot.writeBinary(struct.endRow);
            }
            if (struct.isSetPrevEndRow()) {
                oprot.writeBinary(struct.prevEndRow);
            }
        }

        public void read(TProtocol prot, TKeyExtent struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
            }
            if (incoming.get(1)) {
                struct.endRow = iprot.readBinary();
                struct.setEndRowIsSet(true);
            }
            if (incoming.get(2)) {
                struct.prevEndRow = iprot.readBinary();
                struct.setPrevEndRowIsSet(true);
            }
        }
    }

    private static class TKeyExtentTupleSchemeFactory
    implements SchemeFactory {
        private TKeyExtentTupleSchemeFactory() {
        }

        public TKeyExtentTupleScheme getScheme() {
            return new TKeyExtentTupleScheme();
        }
    }

    private static class TKeyExtentStandardScheme
    extends StandardScheme<TKeyExtent> {
        private TKeyExtentStandardScheme() {
        }

        public void read(TProtocol iprot, TKeyExtent struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.table = iprot.readBinary();
                            struct.setTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.endRow = iprot.readBinary();
                            struct.setEndRowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.prevEndRow = iprot.readBinary();
                            struct.setPrevEndRowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TKeyExtent struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.table != null) {
                oprot.writeFieldBegin(TABLE_FIELD_DESC);
                oprot.writeBinary(struct.table);
                oprot.writeFieldEnd();
            }
            if (struct.endRow != null) {
                oprot.writeFieldBegin(END_ROW_FIELD_DESC);
                oprot.writeBinary(struct.endRow);
                oprot.writeFieldEnd();
            }
            if (struct.prevEndRow != null) {
                oprot.writeFieldBegin(PREV_END_ROW_FIELD_DESC);
                oprot.writeBinary(struct.prevEndRow);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TKeyExtentStandardSchemeFactory
    implements SchemeFactory {
        private TKeyExtentStandardSchemeFactory() {
        }

        public TKeyExtentStandardScheme getScheme() {
            return new TKeyExtentStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE(1, "table"),
        END_ROW(2, "endRow"),
        PREV_END_ROW(3, "prevEndRow");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE;
                }
                case 2: {
                    return END_ROW;
                }
                case 3: {
                    return PREV_END_ROW;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

