/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.impl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.file.blockfile.ABlockReader;
import org.apache.accumulo.core.file.blockfile.ABlockWriter;
import org.apache.accumulo.core.file.blockfile.BlockFileReader;
import org.apache.accumulo.core.file.blockfile.BlockFileWriter;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.file.blockfile.cache.CacheEntry;
import org.apache.accumulo.core.file.blockfile.impl.SeekableByteArrayInputStream;
import org.apache.accumulo.core.file.rfile.bcfile.BCFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachableBlockFile {
    private static final Logger log = LoggerFactory.getLogger(CachableBlockFile.class);

    private CachableBlockFile() {
    }

    public static class BlockRead
    extends DataInputStream
    implements ABlockReader {
        public BlockRead(InputStream in, long size) {
            super(in);
        }

        @Override
        public DataInputStream getStream() throws IOException {
            return this;
        }

        @Override
        public boolean isIndexable() {
            return false;
        }

        @Override
        public void seek(int position) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T getIndex(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getBuffer() {
            throw new UnsupportedOperationException();
        }
    }

    public static class CachedBlockRead
    extends BlockRead {
        private SeekableByteArrayInputStream seekableInput;
        private final CacheEntry cb;

        public CachedBlockRead(CacheEntry cb, byte[] buf) {
            this(new SeekableByteArrayInputStream(buf), buf.length, cb);
        }

        private CachedBlockRead(SeekableByteArrayInputStream seekableInput, long size, CacheEntry cb) {
            super(seekableInput, size);
            this.seekableInput = seekableInput;
            this.cb = cb;
        }

        @Override
        public void seek(int position) {
            this.seekableInput.seek(position);
        }

        @Override
        public int getPosition() {
            return this.seekableInput.getPosition();
        }

        @Override
        public boolean isIndexable() {
            return true;
        }

        @Override
        public byte[] getBuffer() {
            return this.seekableInput.getBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T getIndex(Class<T> clazz) {
            Object bi = null;
            CacheEntry cacheEntry = this.cb;
            synchronized (cacheEntry) {
                SoftReference softRef = (SoftReference)this.cb.getIndex();
                if (softRef != null) {
                    bi = softRef.get();
                }
                if (bi == null) {
                    try {
                        bi = clazz.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.cb.setIndex(new SoftReference<Object>(bi));
                }
            }
            return bi;
        }
    }

    public static class Reader
    implements BlockFileReader {
        private BCFile.Reader _bc;
        private String fileName = "not_available";
        private BlockCache _dCache = null;
        private BlockCache _iCache = null;
        private FSDataInputStream fin = null;
        private FileSystem fs;
        private Configuration conf;
        private boolean closed = false;
        private AccumuloConfiguration accumuloConfiguration = null;
        private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

        public Reader(FileSystem fs, Path dataFile, Configuration conf, BlockCache data, BlockCache index, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this.fileName = dataFile.toString();
            this._dCache = data;
            this._iCache = index;
            this.fs = fs;
            this.conf = conf;
            this.accumuloConfiguration = accumuloConfiguration;
        }

        public Reader(FSDataInputStream fsin, long len, Configuration conf, BlockCache data, BlockCache index, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this._dCache = data;
            this._iCache = index;
            this.init(fsin, len, conf, accumuloConfiguration);
        }

        public Reader(FSDataInputStream fsin, long len, Configuration conf, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this.init(fsin, len, conf, accumuloConfiguration);
        }

        private void init(FSDataInputStream fsin, long len, Configuration conf, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this._bc = new BCFile.Reader(this, fsin, len, conf, accumuloConfiguration);
        }

        private synchronized BCFile.Reader getBCFile(AccumuloConfiguration accumuloConfiguration) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("File " + this.fileName + " is closed");
            }
            if (this._bc == null) {
                Path path = new Path(this.fileName);
                this.fin = this.fs.open(path);
                this.init(this.fin, this.fs.getFileStatus(path).getLen(), this.conf, accumuloConfiguration);
            }
            return this._bc;
        }

        public BlockRead getCachedMetaBlock(String blockName) throws IOException {
            CacheEntry cacheEntry;
            String _lookup = this.fileName + "M" + blockName;
            if (this._iCache != null && (cacheEntry = this._iCache.getBlock(_lookup)) != null) {
                return new CachedBlockRead(cacheEntry, cacheEntry.getBuffer());
            }
            return null;
        }

        public BlockRead cacheMetaBlock(String blockName, BCFile.Reader.BlockReader _currBlock) throws IOException {
            String _lookup = this.fileName + "M" + blockName;
            return this.cacheBlock(_lookup, this._iCache, _currBlock, blockName);
        }

        public void cacheMetaBlock(String blockName, byte[] b) {
            if (this._iCache == null) {
                return;
            }
            String _lookup = this.fileName + "M" + blockName;
            try {
                this._iCache.cacheBlock(_lookup, b);
            }
            catch (Exception e) {
                log.warn("Already cached block: " + _lookup, (Throwable)e);
            }
        }

        private BlockRead getBlock(String _lookup, BlockCache cache, BlockLoader loader) throws IOException {
            if (cache != null) {
                CacheEntry cb = null;
                cb = cache.getBlock(_lookup);
                if (cb != null) {
                    return new CachedBlockRead(cb, cb.getBuffer());
                }
            }
            BCFile.Reader.BlockReader _currBlock = loader.get();
            return this.cacheBlock(_lookup, cache, _currBlock, loader.getInfo());
        }

        private BlockRead cacheBlock(String _lookup, BlockCache cache, BCFile.Reader.BlockReader _currBlock, String block) throws IOException {
            if (cache == null || _currBlock.getRawSize() > Math.min(cache.getMaxSize(), 0x7FFFFFF7L)) {
                return new BlockRead(_currBlock, _currBlock.getRawSize());
            }
            byte[] b = null;
            try {
                b = new byte[(int)_currBlock.getRawSize()];
                _currBlock.readFully(b);
            }
            catch (IOException e) {
                log.debug("Error full blockRead for file " + this.fileName + " for block " + block, (Throwable)e);
                throw e;
            }
            finally {
                _currBlock.close();
            }
            CacheEntry ce = null;
            try {
                ce = cache.cacheBlock(_lookup, b);
            }
            catch (Exception e) {
                log.warn("Already cached block: " + _lookup, (Throwable)e);
            }
            if (ce == null) {
                return new BlockRead(new DataInputStream(new ByteArrayInputStream(b)), b.length);
            }
            return new CachedBlockRead(ce, ce.getBuffer());
        }

        @Override
        public BlockRead getMetaBlock(String blockName) throws IOException {
            String _lookup = this.fileName + "M" + blockName;
            return this.getBlock(_lookup, this._iCache, new MetaBlockLoader(blockName, this.accumuloConfiguration));
        }

        @Override
        public ABlockReader getMetaBlock(long offset, long compressedSize, long rawSize) throws IOException {
            String _lookup = this.fileName + "R" + offset;
            return this.getBlock(_lookup, this._iCache, new RawBlockLoader(offset, compressedSize, rawSize));
        }

        @Override
        public BlockRead getDataBlock(int blockIndex) throws IOException {
            String _lookup = this.fileName + "O" + blockIndex;
            return this.getBlock(_lookup, this._dCache, new OffsetBlockLoader(blockIndex));
        }

        @Override
        public ABlockReader getDataBlock(long offset, long compressedSize, long rawSize) throws IOException {
            String _lookup = this.fileName + "R" + offset;
            return this.getBlock(_lookup, this._dCache, new RawBlockLoader(offset, compressedSize, rawSize));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this._bc != null) {
                this._bc.close();
            }
            if (this.fin != null) {
                FSDataInputStream fSDataInputStream = this.fin;
                synchronized (fSDataInputStream) {
                    this.fin.close();
                }
            }
        }

        private class MetaBlockLoader
        implements BlockLoader {
            private String name;
            private AccumuloConfiguration accumuloConfiguration;

            MetaBlockLoader(String name, AccumuloConfiguration accumuloConfiguration) {
                this.name = name;
                this.accumuloConfiguration = accumuloConfiguration;
            }

            @Override
            public BCFile.Reader.BlockReader get() throws IOException {
                return Reader.this.getBCFile(this.accumuloConfiguration).getMetaBlock(this.name);
            }

            @Override
            public String getInfo() {
                return this.name;
            }
        }

        private class RawBlockLoader
        implements BlockLoader {
            private long offset;
            private long compressedSize;
            private long rawSize;

            RawBlockLoader(long offset, long compressedSize, long rawSize) {
                this.offset = offset;
                this.compressedSize = compressedSize;
                this.rawSize = rawSize;
            }

            @Override
            public BCFile.Reader.BlockReader get() throws IOException {
                return Reader.this.getBCFile(Reader.this.accumuloConfiguration).getDataBlock(this.offset, this.compressedSize, this.rawSize);
            }

            @Override
            public String getInfo() {
                return "" + this.offset + "," + this.compressedSize + "," + this.rawSize;
            }
        }

        private class OffsetBlockLoader
        implements BlockLoader {
            private int blockIndex;

            OffsetBlockLoader(int blockIndex) {
                this.blockIndex = blockIndex;
            }

            @Override
            public BCFile.Reader.BlockReader get() throws IOException {
                return Reader.this.getBCFile(Reader.this.accumuloConfiguration).getDataBlock(this.blockIndex);
            }

            @Override
            public String getInfo() {
                return "" + this.blockIndex;
            }
        }

        private static interface BlockLoader {
            public BCFile.Reader.BlockReader get() throws IOException;

            public String getInfo();
        }
    }

    public static class BlockWrite
    extends DataOutputStream
    implements ABlockWriter {
        BCFile.Writer.BlockAppender _ba;

        public BlockWrite(BCFile.Writer.BlockAppender ba) {
            super(ba);
            this._ba = ba;
        }

        @Override
        public long getCompressedSize() throws IOException {
            return this._ba.getCompressedSize();
        }

        @Override
        public long getRawSize() throws IOException {
            return this._ba.getRawSize();
        }

        @Override
        public void close() throws IOException {
            this._ba.close();
        }

        @Override
        public long getStartPos() throws IOException {
            return this._ba.getStartPos();
        }
    }

    public static class Writer
    implements BlockFileWriter {
        private BCFile.Writer _bc;
        private BlockWrite _bw;
        private FSDataOutputStream fsout = null;

        public Writer(FileSystem fs, Path fName, String compressAlgor, Configuration conf, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this.fsout = fs.create(fName);
            this.init(this.fsout, compressAlgor, conf, accumuloConfiguration);
        }

        public Writer(FSDataOutputStream fsout, String compressAlgor, Configuration conf, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this.fsout = fsout;
            this.init(fsout, compressAlgor, conf, accumuloConfiguration);
        }

        private void init(FSDataOutputStream fsout, String compressAlgor, Configuration conf, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this._bc = new BCFile.Writer(fsout, compressAlgor, conf, false, accumuloConfiguration);
        }

        @Override
        public ABlockWriter prepareMetaBlock(String name) throws IOException {
            this._bw = new BlockWrite(this._bc.prepareMetaBlock(name));
            return this._bw;
        }

        @Override
        public ABlockWriter prepareDataBlock() throws IOException {
            this._bw = new BlockWrite(this._bc.prepareDataBlock());
            return this._bw;
        }

        @Override
        public void close() throws IOException {
            this._bw.close();
            this._bc.close();
            if (this.fsout != null) {
                this.fsout.close();
            }
        }
    }
}

