/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import org.apache.commons.math.stat.StatUtils;

class RollingStats {
    private int position = 0;
    private double[] window;
    private double average;
    private double variance;
    private double stddev;
    private boolean windowFull = false;
    private int recomputeCounter = 0;

    RollingStats(int windowSize) {
        this.window = new double[windowSize];
    }

    private void update(double newValue, double oldValue, int windowSize) {
        double delta = newValue - oldValue;
        double oldAverage = this.average;
        this.average += delta / (double)windowSize;
        this.variance += delta * (newValue - this.average + oldValue - oldAverage) / (double)(windowSize - 1);
        this.stddev = Math.sqrt(this.variance);
    }

    void addValue(long stat) {
        double old = this.window[this.position];
        this.window[this.position] = stat;
        ++this.position;
        ++this.recomputeCounter;
        if (this.windowFull) {
            this.update(stat, old, this.window.length);
        } else if (this.position == this.window.length) {
            this.computeStats(this.window.length);
            this.windowFull = true;
        }
        if (this.position == this.window.length) {
            this.position = 0;
        }
    }

    private void computeStats(int len) {
        this.average = StatUtils.mean((double[])this.window, (int)0, (int)len);
        this.variance = StatUtils.variance((double[])this.window, (double)this.average, (int)0, (int)len);
        this.stddev = Math.sqrt(this.variance);
        this.recomputeCounter = 0;
    }

    private void computeStats() {
        if (this.windowFull) {
            if (this.variance < 0.0 || this.recomputeCounter >= 100) {
                this.computeStats(this.window.length);
            }
        } else if (this.recomputeCounter > 0) {
            this.computeStats(this.position);
        }
    }

    double getMean() {
        this.computeStats();
        return this.average;
    }

    double getVariance() {
        this.computeStats();
        return this.variance;
    }

    double getStandardDeviation() {
        this.computeStats();
        return this.stddev;
    }

    boolean isWindowFull() {
        return this.windowFull;
    }
}

