/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.kafka.KafkaAdminFactory;
import io.trino.plugin.kafka.KafkaConsumerFactory;
import io.trino.plugin.kafka.KafkaProducerFactory;
import io.trino.plugin.kafka.KafkaSecurityConfig;
import io.trino.plugin.kafka.PlainTextKafkaAdminFactory;
import io.trino.plugin.kafka.PlainTextKafkaConsumerFactory;
import io.trino.plugin.kafka.PlainTextKafkaProducerFactory;
import io.trino.plugin.kafka.SslKafkaAdminFactory;
import io.trino.plugin.kafka.SslKafkaConsumerFactory;
import io.trino.plugin.kafka.SslKafkaProducerFactory;
import io.trino.plugin.kafka.security.ForKafkaSsl;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaClientsModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(KafkaSecurityConfig.class);
        this.installClientModule(SecurityProtocol.PLAINTEXT, KafkaClientsModule::configurePlainText);
        this.installClientModule(SecurityProtocol.SSL, KafkaClientsModule::configureSsl);
    }

    private void installClientModule(SecurityProtocol securityProtocol, Module module) {
        this.install(ConditionalModule.conditionalModule(KafkaSecurityConfig.class, config -> config.getSecurityProtocol().equals((Object)securityProtocol), (Module)module));
    }

    private static void configurePlainText(Binder binder) {
        binder.bind(KafkaConsumerFactory.class).to(PlainTextKafkaConsumerFactory.class).in(Scopes.SINGLETON);
        binder.bind(KafkaProducerFactory.class).to(PlainTextKafkaProducerFactory.class).in(Scopes.SINGLETON);
        binder.bind(KafkaAdminFactory.class).to(PlainTextKafkaAdminFactory.class).in(Scopes.SINGLETON);
    }

    private static void configureSsl(Binder binder) {
        binder.bind(KafkaConsumerFactory.class).annotatedWith(ForKafkaSsl.class).to(PlainTextKafkaConsumerFactory.class).in(Scopes.SINGLETON);
        binder.bind(KafkaProducerFactory.class).annotatedWith(ForKafkaSsl.class).to(PlainTextKafkaProducerFactory.class).in(Scopes.SINGLETON);
        binder.bind(KafkaAdminFactory.class).annotatedWith(ForKafkaSsl.class).to(PlainTextKafkaAdminFactory.class).in(Scopes.SINGLETON);
        binder.bind(KafkaConsumerFactory.class).to(SslKafkaConsumerFactory.class).in(Scopes.SINGLETON);
        binder.bind(KafkaProducerFactory.class).to(SslKafkaProducerFactory.class).in(Scopes.SINGLETON);
        binder.bind(KafkaAdminFactory.class).to(SslKafkaAdminFactory.class).in(Scopes.SINGLETON);
    }
}

