/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.trino.spi.HostAddress;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@DefunctConfig(value={"kafka.connect-timeout"})
public class KafkaConfig {
    private static final int KAFKA_DEFAULT_PORT = 9092;
    private Set<HostAddress> nodes = ImmutableSet.of();
    private DataSize kafkaBufferSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private String defaultSchema = "default";
    private boolean hideInternalColumns = true;
    private int messagesPerSplit = 100000;
    private boolean timestampUpperBoundPushDownEnabled;
    private String tableDescriptionSupplier = "file";

    @Size(min=1)
    public @Size(min=1) Set<HostAddress> getNodes() {
        return this.nodes;
    }

    @Config(value="kafka.nodes")
    @ConfigDescription(value="Seed nodes for Kafka cluster. At least one must exist")
    public KafkaConfig setNodes(String nodes) {
        this.nodes = nodes == null ? null : KafkaConfig.parseNodes(nodes);
        return this;
    }

    public DataSize getKafkaBufferSize() {
        return this.kafkaBufferSize;
    }

    @Config(value="kafka.buffer-size")
    @ConfigDescription(value="Kafka message consumer buffer size")
    public KafkaConfig setKafkaBufferSize(String kafkaBufferSize) {
        this.kafkaBufferSize = DataSize.valueOf((String)kafkaBufferSize);
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="kafka.default-schema")
    @ConfigDescription(value="Schema name to use in the connector")
    public KafkaConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @NotNull
    public String getTableDescriptionSupplier() {
        return this.tableDescriptionSupplier;
    }

    @Config(value="kafka.table-description-supplier")
    @ConfigDescription(value="The table description supplier to use, default is FILE")
    public KafkaConfig setTableDescriptionSupplier(String tableDescriptionSupplier) {
        this.tableDescriptionSupplier = tableDescriptionSupplier;
        return this;
    }

    public boolean isHideInternalColumns() {
        return this.hideInternalColumns;
    }

    @Config(value="kafka.hide-internal-columns")
    @ConfigDescription(value="Whether internal columns are shown in table metadata or not. Default is no")
    public KafkaConfig setHideInternalColumns(boolean hideInternalColumns) {
        this.hideInternalColumns = hideInternalColumns;
        return this;
    }

    private static ImmutableSet<HostAddress> parseNodes(String nodes) {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        return (ImmutableSet)StreamSupport.stream(splitter.split((CharSequence)nodes).spliterator(), false).map(KafkaConfig::toHostAddress).collect(ImmutableSet.toImmutableSet());
    }

    private static HostAddress toHostAddress(String value) {
        return HostAddress.fromString((String)value).withDefaultPort(9092);
    }

    @Min(value=1L)
    public @Min(value=1L) int getMessagesPerSplit() {
        return this.messagesPerSplit;
    }

    @Config(value="kafka.messages-per-split")
    @ConfigDescription(value="Count of Kafka messages to be processed by single Trino Kafka connector split")
    public KafkaConfig setMessagesPerSplit(int messagesPerSplit) {
        this.messagesPerSplit = messagesPerSplit;
        return this;
    }

    public boolean isTimestampUpperBoundPushDownEnabled() {
        return this.timestampUpperBoundPushDownEnabled;
    }

    @Config(value="kafka.timestamp-upper-bound-force-push-down-enabled")
    @ConfigDescription(value="timestamp upper bound force pushing down enabled")
    public KafkaConfig setTimestampUpperBoundPushDownEnabled(boolean timestampUpperBoundPushDownEnabled) {
        this.timestampUpperBoundPushDownEnabled = timestampUpperBoundPushDownEnabled;
        return this;
    }
}

