/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.kafka.KafkaConnector;
import io.trino.plugin.kafka.KafkaConnectorModule;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;

public class KafkaConnectorFactory
implements ConnectorFactory {
    private final Module extension;

    public KafkaConnectorFactory(Module extension) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
    }

    public String getName() {
        return "kafka";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new CatalogNameModule(catalogName), new JsonModule(), new TypeDeserializerModule(context.getTypeManager()), new KafkaConnectorModule(), this.extension, binder -> {
            binder.bind(ClassLoader.class).toInstance((Object)KafkaConnectorFactory.class.getClassLoader());
            binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(KafkaConnector.class);
    }
}

