/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.decoder.DispatchingRowDecoderFactory;
import io.trino.decoder.RowDecoder;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.plugin.kafka.KafkaConsumerFactory;
import io.trino.plugin.kafka.KafkaRecordSet;
import io.trino.plugin.kafka.KafkaSplit;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class KafkaRecordSetProvider
implements ConnectorRecordSetProvider {
    private final DispatchingRowDecoderFactory decoderFactory;
    private final KafkaConsumerFactory consumerFactory;

    @Inject
    public KafkaRecordSetProvider(DispatchingRowDecoderFactory decoderFactory, KafkaConsumerFactory consumerFactory) {
        this.decoderFactory = Objects.requireNonNull(decoderFactory, "decoderFactory is null");
        this.consumerFactory = Objects.requireNonNull(consumerFactory, "consumerFactory is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        KafkaSplit kafkaSplit = (KafkaSplit)split;
        List kafkaColumns = (List)columns.stream().map(KafkaColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        RowDecoder keyDecoder = this.decoderFactory.create(kafkaSplit.getKeyDataFormat(), KafkaRecordSetProvider.getDecoderParameters(kafkaSplit.getKeyDataSchemaContents()), (Set)kafkaColumns.stream().filter(col -> !col.isInternal()).filter(KafkaColumnHandle::isKeyCodec).collect(ImmutableSet.toImmutableSet()));
        RowDecoder messageDecoder = this.decoderFactory.create(kafkaSplit.getMessageDataFormat(), KafkaRecordSetProvider.getDecoderParameters(kafkaSplit.getMessageDataSchemaContents()), (Set)kafkaColumns.stream().filter(col -> !col.isInternal()).filter(col -> !col.isKeyCodec()).collect(ImmutableSet.toImmutableSet()));
        return new KafkaRecordSet(kafkaSplit, this.consumerFactory, session, kafkaColumns, keyDecoder, messageDecoder);
    }

    private static Map<String, String> getDecoderParameters(Optional<String> dataSchema) {
        ImmutableMap.Builder parameters = ImmutableMap.builder();
        dataSchema.ifPresent(schema -> parameters.put((Object)"dataSchema", schema));
        return parameters.buildOrThrow();
    }
}

