/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import io.airlift.units.DataSize;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaConsumerFactory;
import io.trino.plugin.kafka.KafkaSecurityConfig;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

public class PlainTextKafkaConsumerFactory
implements KafkaConsumerFactory {
    private final Set<HostAddress> nodes;
    private final DataSize kafkaBufferSize;
    private final SecurityProtocol securityProtocol;

    @Inject
    public PlainTextKafkaConsumerFactory(KafkaConfig kafkaConfig, KafkaSecurityConfig securityConfig) {
        Objects.requireNonNull(kafkaConfig, "kafkaConfig is null");
        Objects.requireNonNull(securityConfig, "securityConfig is null");
        this.nodes = kafkaConfig.getNodes();
        this.kafkaBufferSize = kafkaConfig.getKafkaBufferSize();
        this.securityProtocol = securityConfig.getSecurityProtocol();
    }

    @Override
    public Properties configure(ConnectorSession session) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", this.nodes.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
        properties.setProperty("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.setProperty("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.setProperty("receive.buffer.bytes", Long.toString(this.kafkaBufferSize.toBytes()));
        properties.setProperty("enable.auto.commit", Boolean.toString(false));
        properties.setProperty("security.protocol", this.securityProtocol.name());
        return properties;
    }
}

