/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaProducerFactory;
import io.trino.plugin.kafka.KafkaSecurityConfig;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class PlainTextKafkaProducerFactory
implements KafkaProducerFactory {
    private final Set<HostAddress> nodes;
    private final SecurityProtocol securityProtocol;

    @Inject
    public PlainTextKafkaProducerFactory(KafkaConfig kafkaConfig, KafkaSecurityConfig securityConfig) {
        Objects.requireNonNull(kafkaConfig, "kafkaConfig is null");
        Objects.requireNonNull(securityConfig, "securityConfig is null");
        this.nodes = kafkaConfig.getNodes();
        this.securityProtocol = securityConfig.getSecurityProtocol();
    }

    @Override
    public Properties configure(ConnectorSession session) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", this.nodes.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
        properties.setProperty("key.serializer", ByteArraySerializer.class.getName());
        properties.setProperty("value.serializer", ByteArraySerializer.class.getName());
        properties.setProperty("acks", "all");
        properties.setProperty("linger.ms", Long.toString(5L));
        properties.setProperty("security.protocol", this.securityProtocol.name());
        return properties;
    }
}

