/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.trino.plugin.kafka.encoder.EncoderColumnHandle;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractRowEncoder
implements RowEncoder {
    protected final ConnectorSession session;
    protected final List<EncoderColumnHandle> columnHandles;
    protected int currentColumnIndex;

    protected AbstractRowEncoder(ConnectorSession session, List<EncoderColumnHandle> columnHandles) {
        this.session = Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.columnHandles = ImmutableList.copyOf(columnHandles);
        this.currentColumnIndex = 0;
    }

    @Override
    public void appendColumnValue(Block block, int position) {
        Preconditions.checkArgument((this.currentColumnIndex < this.columnHandles.size() ? 1 : 0) != 0, (Object)String.format("currentColumnIndex '%d' is greater than number of columns '%d'", this.currentColumnIndex, this.columnHandles.size()));
        Type type = this.columnHandles.get(this.currentColumnIndex).getType();
        if (block.isNull(position)) {
            this.appendNullValue();
        } else if (type == BooleanType.BOOLEAN) {
            this.appendBoolean(type.getBoolean(block, position));
        } else if (type == BigintType.BIGINT) {
            this.appendLong(type.getLong(block, position));
        } else if (type == IntegerType.INTEGER) {
            this.appendInt(Math.toIntExact(type.getLong(block, position)));
        } else if (type == SmallintType.SMALLINT) {
            this.appendShort(Shorts.checkedCast((long)type.getLong(block, position)));
        } else if (type == TinyintType.TINYINT) {
            this.appendByte(SignedBytes.checkedCast((long)type.getLong(block, position)));
        } else if (type == DoubleType.DOUBLE) {
            this.appendDouble(type.getDouble(block, position));
        } else if (type == RealType.REAL) {
            this.appendFloat(Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position))));
        } else if (type instanceof VarcharType) {
            this.appendString(type.getSlice(block, position).toStringUtf8());
        } else if (type instanceof VarbinaryType) {
            this.appendByteBuffer(type.getSlice(block, position).toByteBuffer());
        } else if (type == DateType.DATE) {
            this.appendSqlDate((SqlDate)type.getObjectValue(this.session, block, position));
        } else if (type instanceof TimeType) {
            this.appendSqlTime((SqlTime)type.getObjectValue(this.session, block, position));
        } else if (type instanceof TimeWithTimeZoneType) {
            this.appendSqlTimeWithTimeZone((SqlTimeWithTimeZone)type.getObjectValue(this.session, block, position));
        } else if (type instanceof TimestampType) {
            this.appendSqlTimestamp((SqlTimestamp)type.getObjectValue(this.session, block, position));
        } else if (type instanceof TimestampWithTimeZoneType) {
            this.appendSqlTimestampWithTimeZone((SqlTimestampWithTimeZone)type.getObjectValue(this.session, block, position));
        } else if (type instanceof ArrayType) {
            this.appendArray((List)type.getObjectValue(this.session, block, position));
        } else if (type instanceof MapType) {
            this.appendMap((Map)type.getObjectValue(this.session, block, position));
        } else if (type instanceof RowType) {
            this.appendRow((List)type.getObjectValue(this.session, block, position));
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", type, this.columnHandles.get(this.currentColumnIndex).getName()));
        }
        ++this.currentColumnIndex;
    }

    protected void appendNullValue() {
        throw new UnsupportedOperationException(String.format("Column '%s' does not support 'null' value", this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendLong(long value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", Long.TYPE.getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendInt(int value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", Integer.TYPE.getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendShort(short value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", Short.TYPE.getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendByte(byte value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", Byte.TYPE.getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendDouble(double value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", Double.TYPE.getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendFloat(float value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", Float.TYPE.getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendBoolean(boolean value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", Boolean.TYPE.getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendString(String value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendByteBuffer(ByteBuffer value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendSqlDate(SqlDate value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendSqlTime(SqlTime value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendSqlTimeWithTimeZone(SqlTimeWithTimeZone value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendSqlTimestamp(SqlTimestamp value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendSqlTimestampWithTimeZone(SqlTimestampWithTimeZone value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendArray(List<Object> value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendMap(Map<Object, Object> value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void appendRow(List<Object> value) {
        throw new UnsupportedOperationException(String.format("Unsupported type '%s' for column '%s'", value.getClass().getName(), this.columnHandles.get(this.currentColumnIndex).getName()));
    }

    protected void resetColumnIndex() {
        this.currentColumnIndex = 0;
    }

    @Override
    public void close() {
    }
}

