/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json.format;

import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.util.TimeConversions;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;

public class SecondsSinceEpochFormatter
implements JsonDateTimeFormatter {
    public static boolean isSupportedType(Type type) {
        return type.equals(TimeType.TIME_MILLIS) || type.equals(TimestampType.TIMESTAMP_MILLIS) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    }

    @Override
    public String formatTime(SqlTime value, int precision) {
        return String.valueOf(TimeConversions.scalePicosToSeconds(value.getPicos()));
    }

    @Override
    public String formatTimestamp(SqlTimestamp value) {
        return String.valueOf(TimeConversions.scaleEpochMillisToSeconds(value.getMillis()));
    }

    @Override
    public String formatTimestampWithZone(SqlTimestampWithTimeZone value) {
        return String.valueOf(TimeConversions.scaleEpochMillisToSeconds(value.getEpochMillis()));
    }
}

