/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.trino.decoder.DispatchingRowDecoderFactory;
import io.trino.decoder.RowDecoderFactory;
import io.trino.decoder.avro.AvroBytesDeserializer;
import io.trino.decoder.avro.AvroDeserializer;
import io.trino.decoder.avro.AvroReaderSupplier;
import io.trino.decoder.avro.AvroRowDecoderFactory;
import io.trino.decoder.dummy.DummyRowDecoderFactory;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.kafka.encoder.DispatchingRowEncoderFactory;
import io.trino.plugin.kafka.encoder.EncoderModule;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.plugin.kafka.schema.ContentSchemaReader;
import io.trino.plugin.kafka.schema.TableDescriptionSupplier;
import io.trino.plugin.kafka.schema.confluent.AvroConfluentContentSchemaReader;
import io.trino.plugin.kafka.schema.confluent.AvroSchemaParser;
import io.trino.plugin.kafka.schema.confluent.ClassLoaderSafeSchemaRegistryClient;
import io.trino.plugin.kafka.schema.confluent.ConfluentAvroReaderSupplier;
import io.trino.plugin.kafka.schema.confluent.ConfluentSchemaRegistryConfig;
import io.trino.plugin.kafka.schema.confluent.ConfluentSchemaRegistryTableDescriptionSupplier;
import io.trino.plugin.kafka.schema.confluent.ConfluentSessionProperties;
import io.trino.plugin.kafka.schema.confluent.SchemaParser;
import io.trino.plugin.kafka.schema.confluent.SchemaRegistryClientPropertiesProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Singleton;

public class ConfluentModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(ConfluentSchemaRegistryConfig.class);
        this.install(new ConfluentDecoderModule());
        this.install(new ConfluentEncoderModule());
        binder.bind(ContentSchemaReader.class).to(AvroConfluentContentSchemaReader.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, SchemaRegistryClientPropertiesProvider.class);
        Multibinder.newSetBinder((Binder)binder, SchemaProvider.class).addBinding().to(AvroSchemaProvider.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(ConfluentSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(TableDescriptionSupplier.class).toProvider(ConfluentSchemaRegistryTableDescriptionSupplier.Factory.class).in(Scopes.SINGLETON);
        MapBinder.newMapBinder((Binder)binder, String.class, SchemaParser.class).addBinding((Object)"AVRO").to(AvroSchemaParser.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static SchemaRegistryClient createSchemaRegistryClient(ConfluentSchemaRegistryConfig confluentConfig, Set<SchemaProvider> schemaProviders, Set<SchemaRegistryClientPropertiesProvider> propertiesProviders, ClassLoader classLoader) {
        Objects.requireNonNull(confluentConfig, "confluentConfig is null");
        Objects.requireNonNull(schemaProviders, "schemaProviders is null");
        Objects.requireNonNull(propertiesProviders, "propertiesProviders is null");
        List baseUrl = (List)confluentConfig.getConfluentSchemaRegistryUrls().stream().map(HostAddress::getHostText).collect(ImmutableList.toImmutableList());
        Map schemaRegistryClientProperties = (Map)propertiesProviders.stream().map(SchemaRegistryClientPropertiesProvider::getSchemaRegistryClientProperties).flatMap(properties -> properties.entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return new ClassLoaderSafeSchemaRegistryClient((SchemaRegistryClient)new CachedSchemaRegistryClient(baseUrl, confluentConfig.getConfluentSchemaRegistryClientCacheSize(), (List)ImmutableList.copyOf(schemaProviders), schemaRegistryClientProperties), classLoader);
    }

    private static class ConfluentEncoderModule
    implements Module {
        private ConfluentEncoderModule() {
        }

        public void configure(Binder binder) {
            MapBinder<String, RowEncoderFactory> encoderFactoriesByName = EncoderModule.encoderFactory(binder);
            encoderFactoriesByName.addBinding((Object)"avro").toInstance((session, dataSchema, columnHandles) -> {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Insert not supported");
            });
            binder.bind(DispatchingRowEncoderFactory.class).in(Scopes.SINGLETON);
        }
    }

    private static class ConfluentDecoderModule
    implements Module {
        private ConfluentDecoderModule() {
        }

        public void configure(Binder binder) {
            binder.bind(AvroReaderSupplier.Factory.class).to(ConfluentAvroReaderSupplier.Factory.class).in(Scopes.SINGLETON);
            binder.bind(AvroDeserializer.Factory.class).to(AvroBytesDeserializer.Factory.class).in(Scopes.SINGLETON);
            MapBinder.newMapBinder((Binder)binder, String.class, RowDecoderFactory.class).addBinding((Object)"avro").to(AvroRowDecoderFactory.class).in(Scopes.SINGLETON);
            MapBinder.newMapBinder((Binder)binder, String.class, RowDecoderFactory.class).addBinding((Object)"dummy").to(DummyRowDecoderFactory.class).in(Scopes.SINGLETON);
            binder.bind(DispatchingRowDecoderFactory.class).in(Scopes.SINGLETON);
        }
    }
}

