/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaTopicDescription;
import io.trino.plugin.kafka.KafkaTopicFieldDescription;
import io.trino.plugin.kafka.KafkaTopicFieldGroup;
import io.trino.plugin.kafka.schema.MapBasedTableDescriptionSupplier;
import io.trino.plugin.kafka.schema.TableDescriptionSupplier;
import io.trino.plugin.kafka.schema.file.FileTableDescriptionSupplierConfig;
import io.trino.spi.connector.SchemaTableName;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;

public class FileTableDescriptionSupplier
implements Provider<TableDescriptionSupplier> {
    public static final String NAME = "file";
    private static final Logger log = Logger.get(FileTableDescriptionSupplier.class);
    private final JsonCodec<KafkaTopicDescription> topicDescriptionCodec;
    private final File tableDescriptionDir;
    private final String defaultSchema;
    private final Set<String> tableNames;

    @Inject
    FileTableDescriptionSupplier(FileTableDescriptionSupplierConfig config, KafkaConfig kafkaConfig, JsonCodec<KafkaTopicDescription> topicDescriptionCodec) {
        this.topicDescriptionCodec = Objects.requireNonNull(topicDescriptionCodec, "topicDescriptionCodec is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(kafkaConfig, "kafkaConfig is null");
        this.tableDescriptionDir = config.getTableDescriptionDir();
        this.defaultSchema = kafkaConfig.getDefaultSchema();
        this.tableNames = ImmutableSet.copyOf(config.getTableNames());
    }

    public TableDescriptionSupplier get() {
        Map<SchemaTableName, KafkaTopicDescription> tables = this.populateTables();
        return new MapBasedTableDescriptionSupplier(tables);
    }

    private Map<SchemaTableName, KafkaTopicDescription> populateTables() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        log.debug("Loading kafka table definitions from %s", new Object[]{this.tableDescriptionDir.getAbsolutePath()});
        try {
            for (File file : FileTableDescriptionSupplier.listFiles(this.tableDescriptionDir)) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                KafkaTopicDescription table = (KafkaTopicDescription)this.topicDescriptionCodec.fromJson(Files.readAllBytes(file.toPath()));
                String schemaName = table.getSchemaName().orElse(this.defaultSchema);
                log.debug("Kafka table %s.%s: %s", new Object[]{schemaName, table.getTableName(), table});
                builder.put((Object)new SchemaTableName(schemaName, table.getTableName()), (Object)table);
            }
            ImmutableMap tableDefinitions = builder.buildOrThrow();
            log.debug("Loaded Table definitions: %s", new Object[]{tableDefinitions.keySet()});
            builder = ImmutableMap.builder();
            for (String definedTable : this.tableNames) {
                SchemaTableName tableName;
                try {
                    tableName = FileTableDescriptionSupplier.parseTableName(definedTable);
                }
                catch (IllegalArgumentException iae) {
                    tableName = new SchemaTableName(this.defaultSchema, definedTable);
                }
                if (tableDefinitions.containsKey(tableName)) {
                    KafkaTopicDescription kafkaTable = (KafkaTopicDescription)tableDefinitions.get(tableName);
                    log.debug("Found Table definition for %s: %s", new Object[]{tableName, kafkaTable});
                    builder.put((Object)tableName, (Object)kafkaTable);
                    continue;
                }
                log.debug("Created dummy Table definition for %s", new Object[]{tableName});
                builder.put((Object)tableName, (Object)new KafkaTopicDescription(tableName.getTableName(), Optional.ofNullable(tableName.getSchemaName()), definedTable, Optional.of(new KafkaTopicFieldGroup("dummy", Optional.empty(), Optional.empty(), (List<KafkaTopicFieldDescription>)ImmutableList.of())), Optional.of(new KafkaTopicFieldGroup("dummy", Optional.empty(), Optional.empty(), (List<KafkaTopicFieldDescription>)ImmutableList.of()))));
            }
            return builder.buildOrThrow();
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Error: ");
            throw new UncheckedIOException(e);
        }
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            log.debug("Considering files: %s", new Object[]{Arrays.asList(files)});
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static SchemaTableName parseTableName(String schemaTableName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schemaTableName) ? 1 : 0) != 0, (Object)"schemaTableName is null or is empty");
        List parts = Splitter.on((char)'.').splitToList((CharSequence)schemaTableName);
        Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"Invalid schemaTableName: %s", (Object)schemaTableName);
        return new SchemaTableName((String)parts.get(0), (String)parts.get(1));
    }
}

