/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.base.Preconditions;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;

public class OrcBlockFactory {
    private final Function<Exception, RuntimeException> exceptionTransform;
    private final boolean nestedLazy;
    private int currentPageId;

    public OrcBlockFactory(Function<Exception, RuntimeException> exceptionTransform, boolean nestedLazy) {
        this.exceptionTransform = Objects.requireNonNull(exceptionTransform, "exceptionTransform is null");
        this.nestedLazy = nestedLazy;
    }

    public void nextPage() {
        ++this.currentPageId;
    }

    public Block createBlock(int positionCount, OrcBlockReader reader, boolean nested) {
        return new LazyBlock(positionCount, (LazyBlockLoader)new OrcBlockLoader(reader, nested && !this.nestedLazy));
    }

    private final class OrcBlockLoader
    implements LazyBlockLoader {
        private final int expectedPageId;
        private final OrcBlockReader blockReader;
        private final boolean loadFully;
        private boolean loaded;

        public OrcBlockLoader(OrcBlockReader blockReader, boolean loadFully) {
            this.expectedPageId = OrcBlockFactory.this.currentPageId;
            this.blockReader = Objects.requireNonNull(blockReader, "blockReader is null");
            this.loadFully = loadFully;
        }

        public final Block load() {
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Preconditions.checkState((OrcBlockFactory.this.currentPageId == this.expectedPageId ? 1 : 0) != 0, (Object)"ORC reader has been advanced beyond block");
            this.loaded = true;
            try {
                Block block = this.blockReader.readBlock();
                if (this.loadFully) {
                    block = block.getLoadedBlock();
                }
                return block;
            }
            catch (IOException | RuntimeException e) {
                throw OrcBlockFactory.this.exceptionTransform.apply(e);
            }
        }
    }

    public static interface OrcBlockReader {
        public Block readBlock() throws IOException;
    }
}

