/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.orc.RowGroup;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.stream.InputStreamSources;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class Stripe {
    private final long rowCount;
    private final ZoneId fileTimeZone;
    private final ColumnMetadata<ColumnEncoding> columnEncodings;
    private final List<RowGroup> rowGroups;
    private final InputStreamSources dictionaryStreamSources;

    public Stripe(long rowCount, ZoneId fileTimeZone, ColumnMetadata<ColumnEncoding> columnEncodings, List<RowGroup> rowGroups, InputStreamSources dictionaryStreamSources) {
        this.rowCount = rowCount;
        this.fileTimeZone = Objects.requireNonNull(fileTimeZone, "fileTimeZone is null");
        this.columnEncodings = Objects.requireNonNull(columnEncodings, "columnEncodings is null");
        this.rowGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(rowGroups, "rowGroups is null"));
        this.dictionaryStreamSources = Objects.requireNonNull(dictionaryStreamSources, "dictionaryStreamSources is null");
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public ZoneId getFileTimeZone() {
        return this.fileTimeZone;
    }

    public ColumnMetadata<ColumnEncoding> getColumnEncodings() {
        return this.columnEncodings;
    }

    public List<RowGroup> getRowGroups() {
        return this.rowGroups;
    }

    public InputStreamSources getDictionaryStreamSources() {
        return this.dictionaryStreamSources;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowCount", this.rowCount).add("fileTimeZone", (Object)this.fileTimeZone).add("columnEncodings", this.columnEncodings).add("rowGroups", this.rowGroups).add("dictionaryStreams", (Object)this.dictionaryStreamSources).toString();
    }
}

