/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public class StripeInformation {
    private final int numberOfRows;
    private final long offset;
    private final long indexLength;
    private final long dataLength;
    private final long footerLength;

    public StripeInformation(int numberOfRows, long offset, long indexLength, long dataLength, long footerLength) {
        Preconditions.checkArgument((numberOfRows > 0 ? 1 : 0) != 0, (Object)"Stripe must have at least one row");
        Preconditions.checkArgument((footerLength > 0L ? 1 : 0) != 0, (Object)"Stripe must have a footer section");
        this.numberOfRows = numberOfRows;
        this.offset = offset;
        this.indexLength = indexLength;
        this.dataLength = dataLength;
        this.footerLength = footerLength;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getIndexLength() {
        return this.indexLength;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public long getFooterLength() {
        return this.footerLength;
    }

    public long getTotalLength() {
        return this.indexLength + this.dataLength + this.footerLength;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRows", this.numberOfRows).add("offset", this.offset).add("indexLength", this.indexLength).add("dataLength", this.dataLength).add("footerLength", this.footerLength).toString();
    }
}

