/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.net.Inet4Address;

public final class IPRange {
    private String ipMin;
    private String ipMax;

    public IPRange(String ip) {
        Utility.assertNotNull("ip", ip);
        IPRange.validateIPAddress(ip);
        this.ipMin = ip;
        this.ipMax = ip;
    }

    public IPRange(String mininimumIP, String maximumIP) {
        Utility.assertNotNull("mininimumIP", mininimumIP);
        Utility.assertNotNull("maximumIP", maximumIP);
        IPRange.validateIPAddress(mininimumIP);
        IPRange.validateIPAddress(maximumIP);
        this.ipMin = mininimumIP;
        this.ipMax = maximumIP;
    }

    public String getIpMin() {
        return this.ipMin;
    }

    public String getIpMax() {
        return this.ipMax;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.ipMin);
        if (!this.ipMin.equals(this.ipMax)) {
            str.append("-");
            str.append(this.ipMax);
        }
        return str.toString();
    }

    private static void validateIPAddress(String ipAddress) {
        try {
            Inet4Address address = (Inet4Address)Inet4Address.getByName(ipAddress);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Error when parsing IPv4 address: IP address '%s' is invalid.", ipAddress), ex);
        }
    }
}

