/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad;

import io.trino.hadoop.$internal.org.apache.kerby.asn1.Asn1Dumper;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Utf8String;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.KrbSequenceOfType;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationType;
import java.io.IOException;
import java.util.List;

public class ADAuthenticationIndicator
extends AuthorizationDataEntry {
    private AuthIndicator myAuthIndicator = new AuthIndicator();

    public ADAuthenticationIndicator() {
        super(AuthorizationType.AD_AUTHENTICAION_INDICATOR);
        this.myAuthIndicator.outerEncodeable = this;
    }

    public ADAuthenticationIndicator(byte[] encoded) throws IOException {
        this();
        this.myAuthIndicator.decode(encoded);
    }

    public List<Asn1Utf8String> getAuthIndicators() {
        return this.myAuthIndicator.getElements();
    }

    public void add(Asn1Utf8String indicator) {
        this.myAuthIndicator.add(indicator);
        this.resetBodyLength();
    }

    public void clear() {
        this.myAuthIndicator.clear();
        this.resetBodyLength();
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        if (this.bodyLength == -1) {
            this.setAuthzData(this.myAuthIndicator.encode());
            this.bodyLength = super.encodingBodyLength();
        }
        return this.bodyLength;
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        super.dumpWith(dumper, indents);
        dumper.newLine();
        this.myAuthIndicator.dumpWith(dumper, indents + 8);
    }

    private static class AuthIndicator
    extends KrbSequenceOfType<Asn1Utf8String> {
        private AuthIndicator() {
        }
    }
}

