/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.trino.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.net.DFSTopologyNodeImpl;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;
import org.apache.hadoop.hdfs.server.protocol.BlockECReconstructionCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;
import org.apache.hadoop.util.IntrusiveCollection;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeDescriptor
extends DatanodeInfo {
    public static final Logger LOG = LoggerFactory.getLogger(DatanodeDescriptor.class);
    public static final DatanodeDescriptor[] EMPTY_ARRAY = new DatanodeDescriptor[0];
    private static final int BLOCKS_SCHEDULED_ROLL_INTERVAL = 600000;
    private final LeavingServiceStatus leavingServiceStatus = new LeavingServiceStatus();
    protected final Map<String, DatanodeStorageInfo> storageMap = new HashMap<String, DatanodeStorageInfo>();
    private final CachedBlocksList pendingCached = new CachedBlocksList(this, CachedBlocksList.Type.PENDING_CACHED);
    private final CachedBlocksList cached = new CachedBlocksList(this, CachedBlocksList.Type.CACHED);
    private final CachedBlocksList pendingUncached = new CachedBlocksList(this, CachedBlocksList.Type.PENDING_UNCACHED);
    private long lastCachingDirectiveSentTimeMs;
    private boolean isAlive = false;
    private boolean needKeyUpdate = false;
    private boolean forceRegistration = false;
    private long bandwidth;
    private final BlockQueue<BlockTargetPair> replicateBlocks = new BlockQueue();
    private final BlockQueue<BlockECReconstructionCommand.BlockECReconstructionInfo> erasurecodeBlocks = new BlockQueue();
    private final BlockQueue<BlockInfo> recoverBlocks = new BlockQueue();
    private final LightWeightHashSet<Block> invalidateBlocks = new LightWeightHashSet();
    private EnumCounters<StorageType> currApproxBlocksScheduled = new EnumCounters<StorageType>(StorageType.class);
    private EnumCounters<StorageType> prevApproxBlocksScheduled = new EnumCounters<StorageType>(StorageType.class);
    private long lastBlocksScheduledRollTime = 0L;
    private int volumeFailures = 0;
    private VolumeFailureSummary volumeFailureSummary = null;
    private boolean disallowed = false;
    private int pendingReplicationWithoutTargets = 0;
    private boolean heartbeatedSinceRegistration = false;

    public DatanodeDescriptor(DatanodeID nodeID) {
        super(nodeID);
        this.updateHeartbeatState(StorageReport.EMPTY_ARRAY, 0L, 0L, 0, 0, null);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation) {
        super(nodeID, networkLocation);
        this.updateHeartbeatState(StorageReport.EMPTY_ARRAY, 0L, 0L, 0, 0, null);
    }

    public CachedBlocksList getPendingCached() {
        return this.pendingCached;
    }

    public CachedBlocksList getCached() {
        return this.cached;
    }

    public CachedBlocksList getPendingUncached() {
        return this.pendingUncached;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    public synchronized boolean needKeyUpdate() {
        return this.needKeyUpdate;
    }

    public synchronized void setNeedKeyUpdate(boolean needKeyUpdate) {
        this.needKeyUpdate = needKeyUpdate;
    }

    public LeavingServiceStatus getLeavingServiceStatus() {
        return this.leavingServiceStatus;
    }

    @VisibleForTesting
    public boolean isHeartbeatedSinceRegistration() {
        return this.heartbeatedSinceRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public DatanodeStorageInfo getStorageInfo(String storageID) {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            return this.storageMap.get(storageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public DatanodeStorageInfo[] getStorageInfos() {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            Collection<DatanodeStorageInfo> storages = this.storageMap.values();
            return storages.toArray(new DatanodeStorageInfo[storages.size()]);
        }
    }

    public EnumSet<StorageType> getStorageTypes() {
        EnumSet<StorageType> storageTypes = EnumSet.noneOf(StorageType.class);
        for (DatanodeStorageInfo dsi : this.getStorageInfos()) {
            storageTypes.add(dsi.getStorageType());
        }
        return storageTypes;
    }

    public StorageReport[] getStorageReports() {
        DatanodeStorageInfo[] infos = this.getStorageInfos();
        StorageReport[] reports = new StorageReport[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            reports[i] = infos[i].toStorageReport();
        }
        return reports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasStaleStorages() {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            for (DatanodeStorageInfo storage : this.storageMap.values()) {
                if (StorageType.PROVIDED.equals((Object)storage.getStorageType()) || !storage.areBlockContentsStale()) continue;
                return true;
            }
            return false;
        }
    }

    public void resetBlocks() {
        this.updateStorageStats(this.getStorageReports(), 0L, 0L, 0, 0, null);
        this.invalidateBlocks.clear();
        this.volumeFailures = 0;
        this.pendingCached.clear();
        this.cached.clear();
        this.pendingUncached.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBlockQueues() {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            this.invalidateBlocks.clear();
        }
        this.recoverBlocks.clear();
        this.replicateBlocks.clear();
        this.erasurecodeBlocks.clear();
        this.pendingCached.clear();
        this.cached.clear();
        this.pendingUncached.clear();
    }

    public int numBlocks() {
        int blocks = 0;
        for (DatanodeStorageInfo entry : this.getStorageInfos()) {
            blocks += entry.numBlocks();
        }
        return blocks;
    }

    public void updateHeartbeat(StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int volFailures, VolumeFailureSummary volumeFailureSummary) {
        this.updateHeartbeatState(reports, cacheCapacity, cacheUsed, xceiverCount, volFailures, volumeFailureSummary);
        this.heartbeatedSinceRegistration = true;
    }

    public void updateHeartbeatState(StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int volFailures, VolumeFailureSummary volumeFailureSummary) {
        this.updateStorageStats(reports, cacheCapacity, cacheUsed, xceiverCount, volFailures, volumeFailureSummary);
        this.setLastUpdate(Time.now());
        this.setLastUpdateMonotonic(Time.monotonicNow());
        this.rollBlocksScheduled(this.getLastUpdateMonotonic());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void updateStorageStats(StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int volFailures, VolumeFailureSummary volumeFailureSummary) {
        boolean checkFailedStorages;
        long totalCapacity = 0L;
        long totalRemaining = 0L;
        long totalBlockPoolUsed = 0L;
        long totalDfsUsed = 0L;
        long totalNonDfsUsed = 0L;
        HashSet<DatanodeStorageInfo> failedStorageInfos = null;
        if (volumeFailureSummary != null && this.volumeFailureSummary != null) {
            checkFailedStorages = volumeFailureSummary.getLastVolumeFailureDate() > this.volumeFailureSummary.getLastVolumeFailureDate();
        } else {
            boolean bl = checkFailedStorages = volFailures > this.volumeFailures || !this.heartbeatedSinceRegistration;
        }
        if (checkFailedStorages) {
            if (this.volumeFailures != volFailures) {
                LOG.info("Number of failed storages changes from {} to {}", (Object)this.volumeFailures, (Object)volFailures);
            }
            StorageReport[] storageReportArray = this.storageMap;
            // MONITORENTER : this.storageMap
            failedStorageInfos = new HashSet<DatanodeStorageInfo>(this.storageMap.values());
            // MONITOREXIT : storageReportArray
        }
        this.setCacheCapacity(cacheCapacity);
        this.setCacheUsed(cacheUsed);
        this.setXceiverCount(xceiverCount);
        this.volumeFailures = volFailures;
        this.volumeFailureSummary = volumeFailureSummary;
        for (StorageReport report : reports) {
            DatanodeStorageInfo storage = this.storageMap.get(report.getStorage().getStorageID());
            if (checkFailedStorages) {
                failedStorageInfos.remove(storage);
            }
            storage.receivedHeartbeat(report);
            if (StorageType.PROVIDED.equals((Object)storage.getStorageType())) continue;
            totalCapacity += report.getCapacity();
            totalRemaining += report.getRemaining();
            totalBlockPoolUsed += report.getBlockPoolUsed();
            totalDfsUsed += report.getDfsUsed();
            totalNonDfsUsed += report.getNonDfsUsed();
        }
        this.setCapacity(totalCapacity);
        this.setRemaining(totalRemaining);
        this.setBlockPoolUsed(totalBlockPoolUsed);
        this.setDfsUsed(totalDfsUsed);
        this.setNonDfsUsed(totalNonDfsUsed);
        if (checkFailedStorages) {
            this.updateFailedStorage(failedStorageInfos);
        }
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        // MONITORENTER : map
        long storageMapSize = this.storageMap.size();
        // MONITOREXIT : map
        if (storageMapSize == (long)reports.length) return;
        this.pruneStorageMap(reports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectStorage(DatanodeStorageInfo s) {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            DatanodeStorageInfo storage = this.storageMap.get(s.getStorageID());
            if (null == storage) {
                StorageType type;
                LOG.info("Adding new storage ID {} for DN {}", (Object)s.getStorageID(), (Object)this.getXferAddr());
                DFSTopologyNodeImpl parent = null;
                if (this.getParent() instanceof DFSTopologyNodeImpl) {
                    parent = (DFSTopologyNodeImpl)this.getParent();
                }
                if (!this.hasStorageType(type = s.getStorageType()) && parent != null) {
                    parent.childAddStorage(this.getName(), type);
                }
                this.storageMap.put(s.getStorageID(), s);
            } else assert (storage == s) : "found " + storage + " expected " + s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneStorageMap(StorageReport[] reports) {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            LOG.debug("Number of storages reported in heartbeat={}; Number of storages in storageMap={}", (Object)reports.length, (Object)this.storageMap.size());
            HashMap<String, DatanodeStorageInfo> excessStorages = new HashMap<String, DatanodeStorageInfo>(this.storageMap);
            for (StorageReport report : reports) {
                excessStorages.remove(report.getStorage().getStorageID());
            }
            for (DatanodeStorageInfo storageInfo : excessStorages.values()) {
                if (storageInfo.numBlocks() == 0) {
                    DatanodeStorageInfo info = this.storageMap.remove(storageInfo.getStorageID());
                    if (!this.hasStorageType(info.getStorageType()) && this.getParent() instanceof DFSTopologyNodeImpl) {
                        ((DFSTopologyNodeImpl)this.getParent()).childRemoveStorage(this.getName(), info.getStorageType());
                    }
                    LOG.info("Removed storage {} from DataNode {}", (Object)storageInfo, (Object)this);
                    continue;
                }
                LOG.debug("Deferring removal of stale storage {} with {} blocks", (Object)storageInfo, (Object)storageInfo.numBlocks());
            }
        }
    }

    private void updateFailedStorage(Set<DatanodeStorageInfo> failedStorageInfos) {
        for (DatanodeStorageInfo storageInfo : failedStorageInfos) {
            if (storageInfo.getState() == DatanodeStorage.State.FAILED) continue;
            LOG.info("{} failed.", (Object)storageInfo);
            storageInfo.setState(DatanodeStorage.State.FAILED);
        }
    }

    Iterator<BlockInfo> getBlockIterator() {
        return this.getBlockIterator(0);
    }

    Iterator<BlockInfo> getBlockIterator(int startBlock) {
        return new BlockIterator(startBlock, this.getStorageInfos());
    }

    void incrementPendingReplicationWithoutTargets() {
        ++this.pendingReplicationWithoutTargets;
    }

    void decrementPendingReplicationWithoutTargets() {
        --this.pendingReplicationWithoutTargets;
    }

    void addBlockToBeReplicated(Block block, DatanodeStorageInfo[] targets) {
        assert (block != null && targets != null && targets.length > 0);
        this.replicateBlocks.offer(new BlockTargetPair(block, targets));
    }

    void addBlockToBeErasureCoded(ExtendedBlock block, DatanodeDescriptor[] sources, DatanodeStorageInfo[] targets, byte[] liveBlockIndices, ErasureCodingPolicy ecPolicy) {
        assert (block != null && sources != null && sources.length > 0);
        BlockECReconstructionCommand.BlockECReconstructionInfo task = new BlockECReconstructionCommand.BlockECReconstructionInfo(block, sources, targets, liveBlockIndices, ecPolicy);
        this.erasurecodeBlocks.offer(task);
        BlockManager.LOG.debug("Adding block reconstruction task " + task + "to " + this.getName() + ", current queue size is " + this.erasurecodeBlocks.size());
    }

    void addBlockToBeRecovered(BlockInfo block) {
        if (this.recoverBlocks.contains(block)) {
            BlockManager.LOG.info(block + " is already in the recovery queue");
            return;
        }
        this.recoverBlocks.offer(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlocksToBeInvalidated(List<Block> blocklist) {
        assert (blocklist != null && blocklist.size() > 0);
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            for (Block blk : blocklist) {
                this.invalidateBlocks.add(blk);
            }
        }
    }

    int getNumberOfBlocksToBeReplicated() {
        return this.pendingReplicationWithoutTargets + this.replicateBlocks.size();
    }

    @VisibleForTesting
    public int getNumberOfBlocksToBeErasureCoded() {
        return this.erasurecodeBlocks.size();
    }

    int getNumberOfReplicateBlocks() {
        return this.replicateBlocks.size();
    }

    List<BlockTargetPair> getReplicationCommand(int maxTransfers) {
        return this.replicateBlocks.poll(maxTransfers);
    }

    public List<BlockECReconstructionCommand.BlockECReconstructionInfo> getErasureCodeCommand(int maxTransfers) {
        return this.erasurecodeBlocks.poll(maxTransfers);
    }

    public BlockInfo[] getLeaseRecoveryCommand(int maxTransfers) {
        List<BlockInfo> blocks = this.recoverBlocks.poll(maxTransfers);
        if (blocks == null) {
            return null;
        }
        return blocks.toArray(new BlockInfo[blocks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block[] getInvalidateBlocks(int maxblocks) {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            Block[] deleteList = this.invalidateBlocks.pollToArray((Block[])new Block[Math.min(this.invalidateBlocks.size(), maxblocks)]);
            return deleteList.length == 0 ? null : deleteList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean containsInvalidateBlock(Block block) {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            return this.invalidateBlocks.contains(block);
        }
    }

    public DatanodeStorageInfo chooseStorage4Block(StorageType t, long blockSize) {
        long requiredSize = blockSize * 1L;
        long scheduledSize = blockSize * (long)this.getBlocksScheduled(t);
        long remaining = 0L;
        DatanodeStorageInfo storage = null;
        for (DatanodeStorageInfo s : this.getStorageInfos()) {
            long r;
            if (s.getState() != DatanodeStorage.State.NORMAL || s.getStorageType() != t) continue;
            if (storage == null) {
                storage = s;
            }
            if ((r = s.getRemaining()) < requiredSize) continue;
            remaining += r;
        }
        if (requiredSize > remaining - scheduledSize) {
            BlockPlacementPolicy.LOG.debug("The node {} does not have enough {} space (required={}, scheduled={}, remaining={}).", new Object[]{this, t, requiredSize, scheduledSize, remaining});
            return null;
        }
        return storage;
    }

    public int getBlocksScheduled(StorageType t) {
        return (int)(this.currApproxBlocksScheduled.get(t) + this.prevApproxBlocksScheduled.get(t));
    }

    public int getBlocksScheduled() {
        return (int)(this.currApproxBlocksScheduled.sum() + this.prevApproxBlocksScheduled.sum());
    }

    void incrementBlocksScheduled(StorageType t) {
        this.currApproxBlocksScheduled.add(t, 1L);
    }

    void decrementBlocksScheduled(StorageType t) {
        if (this.prevApproxBlocksScheduled.get(t) > 0L) {
            this.prevApproxBlocksScheduled.subtract(t, 1L);
        } else if (this.currApproxBlocksScheduled.get(t) > 0L) {
            this.currApproxBlocksScheduled.subtract(t, 1L);
        }
    }

    private void rollBlocksScheduled(long now) {
        if (now - this.lastBlocksScheduledRollTime > 600000L) {
            this.prevApproxBlocksScheduled.set(this.currApproxBlocksScheduled);
            this.currApproxBlocksScheduled.reset();
            this.lastBlocksScheduledRollTime = now;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public void setDisallowed(boolean flag) {
        this.disallowed = flag;
    }

    public boolean isDisallowed() {
        return this.disallowed;
    }

    public int getVolumeFailures() {
        return this.volumeFailures;
    }

    public VolumeFailureSummary getVolumeFailureSummary() {
        return this.volumeFailureSummary;
    }

    @Override
    public void updateRegInfo(DatanodeID nodeReg) {
        super.updateRegInfo(nodeReg);
        for (DatanodeStorageInfo storage : this.getStorageInfos()) {
            if (storage.getStorageType() == StorageType.PROVIDED) continue;
            storage.setBlockReportCount(0);
        }
        this.heartbeatedSinceRegistration = false;
        this.forceRegistration = false;
    }

    public synchronized long getBalancerBandwidth() {
        return this.bandwidth;
    }

    public synchronized void setBalancerBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    @Override
    public String dumpDatanode() {
        int recover;
        int inval;
        int ec;
        StringBuilder sb = new StringBuilder(super.dumpDatanode());
        int repl = this.replicateBlocks.size();
        if (repl > 0) {
            sb.append(" ").append(repl).append(" blocks to be replicated;");
        }
        if ((ec = this.erasurecodeBlocks.size()) > 0) {
            sb.append(" ").append(ec).append(" blocks to be erasure coded;");
        }
        if ((inval = this.invalidateBlocks.size()) > 0) {
            sb.append(" ").append(inval).append(" blocks to be invalidated;");
        }
        if ((recover = this.recoverBlocks.size()) > 0) {
            sb.append(" ").append(recover).append(" blocks to be recovered;");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeStorageInfo updateStorage(DatanodeStorage s) {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            DatanodeStorageInfo storage = this.storageMap.get(s.getStorageID());
            DFSTopologyNodeImpl parent = null;
            if (this.getParent() instanceof DFSTopologyNodeImpl) {
                parent = (DFSTopologyNodeImpl)this.getParent();
            }
            if (storage == null) {
                LOG.info("Adding new storage ID {} for DN {}", (Object)s.getStorageID(), (Object)this.getXferAddr());
                StorageType type = s.getStorageType();
                if (!this.hasStorageType(type) && parent != null) {
                    parent.childAddStorage(this.getName(), s.getStorageType());
                }
                storage = new DatanodeStorageInfo(this, s);
                this.storageMap.put(s.getStorageID(), storage);
            } else if (storage.getState() != s.getState() || storage.getStorageType() != s.getStorageType()) {
                StorageType newType;
                StorageType oldType = storage.getStorageType();
                if (oldType != (newType = s.getStorageType()) && !this.hasStorageType(newType) && parent != null) {
                    parent.childAddStorage(this.getName(), newType);
                }
                storage.updateFromStorage(s);
                this.storageMap.put(storage.getStorageID(), storage);
                if (oldType != newType && !this.hasStorageType(oldType) && parent != null) {
                    parent.childRemoveStorage(this.getName(), oldType);
                }
            }
            return storage;
        }
    }

    public long getLastCachingDirectiveSentTimeMs() {
        return this.lastCachingDirectiveSentTimeMs;
    }

    public void setLastCachingDirectiveSentTimeMs(long time) {
        this.lastCachingDirectiveSentTimeMs = time;
    }

    public boolean checkBlockReportReceived() {
        if (this.getStorageInfos().length == 0) {
            return false;
        }
        for (DatanodeStorageInfo storageInfo : this.getStorageInfos()) {
            if (storageInfo.getBlockReportCount() != 0) continue;
            return false;
        }
        return true;
    }

    public void setForceRegistration(boolean force) {
        this.forceRegistration = force;
    }

    public boolean isRegistered() {
        return this.isAlive() && !this.forceRegistration;
    }

    public boolean hasStorageType(StorageType type) {
        for (DatanodeStorageInfo dnStorage : this.getStorageInfos()) {
            if (dnStorage.getStorageType() != type) continue;
            return true;
        }
        return false;
    }

    public class LeavingServiceStatus {
        private int underReplicatedBlocks;
        private int underReplicatedBlocksInOpenFiles;
        private int outOfServiceOnlyReplicas;
        private LightWeightHashSet<Long> underReplicatedOpenFiles = new LightWeightLinkedSet<Long>();
        private long startTime;

        synchronized void set(int lowRedundancyBlocksInOpenFiles, LightWeightHashSet<Long> underRepInOpenFiles, int underRepBlocks, int outOfServiceOnlyRep) {
            if (!DatanodeDescriptor.this.isDecommissionInProgress() && !DatanodeDescriptor.this.isEnteringMaintenance()) {
                return;
            }
            this.underReplicatedOpenFiles = underRepInOpenFiles;
            this.underReplicatedBlocks = underRepBlocks;
            this.underReplicatedBlocksInOpenFiles = lowRedundancyBlocksInOpenFiles;
            this.outOfServiceOnlyReplicas = outOfServiceOnlyRep;
        }

        public synchronized int getUnderReplicatedBlocks() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress() && !DatanodeDescriptor.this.isEnteringMaintenance()) {
                return 0;
            }
            return this.underReplicatedBlocks;
        }

        public synchronized int getOutOfServiceOnlyReplicas() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress() && !DatanodeDescriptor.this.isEnteringMaintenance()) {
                return 0;
            }
            return this.outOfServiceOnlyReplicas;
        }

        public synchronized int getUnderReplicatedInOpenFiles() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress() && !DatanodeDescriptor.this.isEnteringMaintenance()) {
                return 0;
            }
            return this.underReplicatedBlocksInOpenFiles;
        }

        public synchronized LightWeightHashSet<Long> getOpenFiles() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress() && !DatanodeDescriptor.this.isEnteringMaintenance()) {
                return new LightWeightLinkedSet<Long>();
            }
            return this.underReplicatedOpenFiles;
        }

        public synchronized void setStartTime(long time) {
            if (!DatanodeDescriptor.this.isDecommissionInProgress() && !DatanodeDescriptor.this.isEnteringMaintenance()) {
                return;
            }
            this.startTime = time;
        }

        public synchronized long getStartTime() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress() && !DatanodeDescriptor.this.isEnteringMaintenance()) {
                return 0L;
            }
            return this.startTime;
        }
    }

    private static class BlockIterator
    implements Iterator<BlockInfo> {
        private int index = 0;
        private final List<Iterator<BlockInfo>> iterators;

        private BlockIterator(int startBlock, DatanodeStorageInfo ... storages) {
            if (startBlock < 0) {
                throw new IllegalArgumentException("Illegal value startBlock = " + startBlock);
            }
            ArrayList<Iterator<BlockInfo>> iterators = new ArrayList<Iterator<BlockInfo>>();
            int s = startBlock;
            int sumBlocks = 0;
            for (DatanodeStorageInfo e : storages) {
                int numBlocks = e.numBlocks();
                if ((sumBlocks += numBlocks) <= startBlock) {
                    s -= numBlocks;
                    continue;
                }
                iterators.add(e.getBlockIterator());
            }
            this.iterators = Collections.unmodifiableList(iterators);
            while (s > 0 && this.hasNext()) {
                this.next();
                --s;
            }
        }

        @Override
        public boolean hasNext() {
            this.update();
            return this.index < this.iterators.size() && this.iterators.get(this.index).hasNext();
        }

        @Override
        public BlockInfo next() {
            this.update();
            return this.iterators.get(this.index).next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove unsupported.");
        }

        private void update() {
            while (this.index < this.iterators.size() - 1 && !this.iterators.get(this.index).hasNext()) {
                ++this.index;
            }
        }
    }

    public static class CachedBlocksList
    extends IntrusiveCollection<CachedBlock> {
        private final DatanodeDescriptor datanode;
        private final Type type;

        CachedBlocksList(DatanodeDescriptor datanode, Type type) {
            this.datanode = datanode;
            this.type = type;
        }

        public DatanodeDescriptor getDatanode() {
            return this.datanode;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            PENDING_CACHED,
            CACHED,
            PENDING_UNCACHED;

        }
    }

    private static class BlockQueue<E> {
        private final Queue<E> blockq = new LinkedList();

        private BlockQueue() {
        }

        synchronized int size() {
            return this.blockq.size();
        }

        synchronized boolean offer(E e) {
            return this.blockq.offer(e);
        }

        synchronized List<E> poll(int numBlocks) {
            if (numBlocks <= 0 || this.blockq.isEmpty()) {
                return null;
            }
            ArrayList<E> results = new ArrayList<E>();
            while (!this.blockq.isEmpty() && numBlocks > 0) {
                results.add(this.blockq.poll());
                --numBlocks;
            }
            return results;
        }

        synchronized boolean contains(E e) {
            return this.blockq.contains(e);
        }

        synchronized void clear() {
            this.blockq.clear();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockTargetPair {
        public final Block block;
        public final DatanodeStorageInfo[] targets;

        BlockTargetPair(Block block, DatanodeStorageInfo[] targets) {
            this.block = block;
            this.targets = targets;
        }
    }
}

