/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.trino.hadoop.TextLineLengthLimitExceededException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class LineReader
implements Closeable {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final byte[] recordDelimiterBytes;
    private int bufferSize = 65536;
    private InputStream in;
    private byte[] buffer;
    private int bufferLength = 0;
    private int bufferPosn = 0;

    public LineReader(InputStream in) {
        this(in, 65536);
    }

    public LineReader(InputStream in, int bufferSize) {
        this.in = in;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
        this.recordDelimiterBytes = null;
    }

    public LineReader(InputStream in, Configuration conf) throws IOException {
        this(in, conf.getInt("io.file.buffer.size", 65536));
    }

    public LineReader(InputStream in, byte[] recordDelimiterBytes) {
        this.in = in;
        this.bufferSize = 65536;
        this.buffer = new byte[this.bufferSize];
        this.recordDelimiterBytes = recordDelimiterBytes;
    }

    public LineReader(InputStream in, int bufferSize, byte[] recordDelimiterBytes) {
        this.in = in;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
        this.recordDelimiterBytes = recordDelimiterBytes;
    }

    public LineReader(InputStream in, Configuration conf, byte[] recordDelimiterBytes) throws IOException {
        this.in = in;
        this.bufferSize = conf.getInt("io.file.buffer.size", 65536);
        this.buffer = new byte[this.bufferSize];
        this.recordDelimiterBytes = recordDelimiterBytes;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        maxLineLength = Math.min(maxLineLength, 0x7FFFFFF7);
        maxBytesToConsume = Math.min(maxBytesToConsume, 0x7FFFFFF7);
        if (this.recordDelimiterBytes != null) {
            return this.readCustomLine(str, maxLineLength, maxBytesToConsume);
        }
        return this.readDefaultLine(str, maxLineLength, maxBytesToConsume);
    }

    protected int fillBuffer(InputStream in, byte[] buffer, boolean inDelimiter) throws IOException {
        return in.read(buffer);
    }

    private int readDefaultLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        str.clear();
        int txtLength = 0;
        int newlineLength = 0;
        boolean prevCharCR = false;
        long bytesConsumed = 0L;
        do {
            int startPosn = this.bufferPosn;
            if (this.bufferPosn >= this.bufferLength) {
                this.bufferPosn = 0;
                startPosn = 0;
                if (prevCharCR) {
                    ++bytesConsumed;
                }
                this.bufferLength = this.fillBuffer(this.in, this.buffer, prevCharCR);
                if (this.bufferLength <= 0) break;
            }
            while (this.bufferPosn < this.bufferLength) {
                if (this.buffer[this.bufferPosn] == 10) {
                    newlineLength = prevCharCR ? 2 : 1;
                    ++this.bufferPosn;
                    break;
                }
                if (prevCharCR) {
                    newlineLength = 1;
                    break;
                }
                prevCharCR = this.buffer[this.bufferPosn] == 13;
                ++this.bufferPosn;
            }
            int readLength = this.bufferPosn - startPosn;
            if (prevCharCR && newlineLength == 0) {
                --readLength;
            }
            bytesConsumed += (long)readLength;
            int appendLength = readLength - newlineLength;
            if (appendLength > maxLineLength - txtLength && (appendLength = maxLineLength - txtLength) > 0) {
                throw new TextLineLengthLimitExceededException("Too many bytes before newline: " + maxLineLength);
            }
            if (appendLength <= 0) continue;
            int newTxtLength = txtLength + appendLength;
            if (str.getBytes().length < newTxtLength && Math.max(newTxtLength, txtLength << 1) > 0x7FFFFFF7) {
                throw new TextLineLengthLimitExceededException("Too many bytes before newline: " + newTxtLength);
            }
            str.append(this.buffer, startPosn, appendLength);
            txtLength = newTxtLength;
        } while (newlineLength == 0 && bytesConsumed < (long)maxBytesToConsume);
        if (newlineLength == 0 && bytesConsumed >= (long)maxBytesToConsume) {
            throw new TextLineLengthLimitExceededException("Too many bytes before newline: " + bytesConsumed);
        }
        return (int)bytesConsumed;
    }

    private int readCustomLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        str.clear();
        int txtLength = 0;
        long bytesConsumed = 0L;
        int delPosn = 0;
        int ambiguousByteCount = 0;
        do {
            int startPosn = this.bufferPosn;
            if (this.bufferPosn >= this.bufferLength) {
                this.bufferPosn = 0;
                startPosn = 0;
                this.bufferLength = this.fillBuffer(this.in, this.buffer, ambiguousByteCount > 0);
                if (this.bufferLength <= 0) {
                    if (ambiguousByteCount <= 0) break;
                    str.append(this.recordDelimiterBytes, 0, ambiguousByteCount);
                    bytesConsumed += (long)ambiguousByteCount;
                    break;
                }
            }
            while (this.bufferPosn < this.bufferLength) {
                if (this.buffer[this.bufferPosn] == this.recordDelimiterBytes[delPosn]) {
                    if (++delPosn >= this.recordDelimiterBytes.length) {
                        ++this.bufferPosn;
                        break;
                    }
                } else if (delPosn != 0) {
                    this.bufferPosn -= delPosn;
                    if (this.bufferPosn < -1) {
                        this.bufferPosn = -1;
                    }
                    delPosn = 0;
                }
                ++this.bufferPosn;
            }
            int readLength = this.bufferPosn - startPosn;
            bytesConsumed += (long)readLength;
            int appendLength = readLength - delPosn;
            if (appendLength > maxLineLength - txtLength && (appendLength = maxLineLength - txtLength) > 0) {
                throw new TextLineLengthLimitExceededException("Too many bytes before delimiter: " + maxLineLength);
            }
            bytesConsumed += (long)ambiguousByteCount;
            if (appendLength >= 0 && ambiguousByteCount > 0) {
                str.append(this.recordDelimiterBytes, 0, ambiguousByteCount);
                ambiguousByteCount = 0;
                this.unsetNeedAdditionalRecordAfterSplit();
            }
            if (appendLength > 0) {
                int newTxtLength = txtLength + appendLength;
                if (str.getBytes().length < newTxtLength && Math.max(newTxtLength, txtLength << 1) > 0x7FFFFFF7) {
                    throw new TextLineLengthLimitExceededException("Too many bytes before delimiter: " + newTxtLength);
                }
                str.append(this.buffer, startPosn, appendLength);
                txtLength = newTxtLength;
            }
            if (this.bufferPosn < this.bufferLength || delPosn <= 0 || delPosn >= this.recordDelimiterBytes.length) continue;
            ambiguousByteCount = delPosn;
            bytesConsumed -= (long)ambiguousByteCount;
        } while (delPosn < this.recordDelimiterBytes.length && bytesConsumed < (long)maxBytesToConsume);
        if (delPosn < this.recordDelimiterBytes.length && bytesConsumed >= (long)maxBytesToConsume) {
            throw new TextLineLengthLimitExceededException("Too many bytes before delimiter: " + bytesConsumed);
        }
        return (int)bytesConsumed;
    }

    public int readLine(Text str, int maxLineLength) throws IOException {
        return this.readLine(str, maxLineLength, Integer.MAX_VALUE);
    }

    public int readLine(Text str) throws IOException {
        return this.readLine(str, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected int getBufferPosn() {
        return this.bufferPosn;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected void unsetNeedAdditionalRecordAfterSplit() {
    }
}

