/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.geospatial.KdbTree;
import io.trino.geospatial.KdbTreeUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public final class KdbTreeType
extends AbstractVariableWidthType {
    public static final KdbTreeType KDB_TREE = new KdbTreeType();
    public static final String NAME = "KdbTree";

    private KdbTreeType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), Object.class);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        return this.getObject(block, position);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getSliceLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        String json = KdbTreeUtils.toJson((KdbTree)((KdbTree)value));
        Slice bytes = Slices.utf8Slice((String)json);
        blockBuilder.writeBytes(bytes, 0, bytes.length()).closeEntry();
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice bytes = block.getSlice(position, 0, block.getSliceLength(position));
        KdbTree kdbTree = KdbTreeUtils.fromJson((String)bytes.toStringUtf8());
        return kdbTree;
    }
}

