/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import io.trino.array.ObjectBigArray;
import io.trino.plugin.geospatial.aggregation.GeometryState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.GroupedAccumulatorState;
import org.openjdk.jol.info.ClassLayout;

public class GeometryStateFactory
implements AccumulatorStateFactory<GeometryState> {
    private static final long OGC_GEOMETRY_BASE_INSTANCE_SIZE = ClassLayout.parseClass(OGCGeometry.class).instanceSize();

    public GeometryState createSingleState() {
        return new SingleGeometryState();
    }

    public GeometryState createGroupedState() {
        return new GroupedGeometryState();
    }

    private static long getGeometryMemorySize(OGCGeometry geometry) {
        if (geometry == null) {
            return 0L;
        }
        if (geometry.isEmpty()) {
            return OGC_GEOMETRY_BASE_INSTANCE_SIZE;
        }
        return geometry.estimateMemorySize();
    }

    public static class SingleGeometryState
    implements GeometryState {
        private OGCGeometry geometry;

        @Override
        public OGCGeometry getGeometry() {
            return this.geometry;
        }

        @Override
        public void setGeometry(OGCGeometry geometry) {
            this.geometry = geometry;
        }

        public long getEstimatedSize() {
            return GeometryStateFactory.getGeometryMemorySize(this.geometry);
        }
    }

    public static class GroupedGeometryState
    implements GeometryState,
    GroupedAccumulatorState {
        private long groupId;
        private ObjectBigArray<OGCGeometry> geometries = new ObjectBigArray();
        private long size;

        @Override
        public OGCGeometry getGeometry() {
            return (OGCGeometry)this.geometries.get(this.groupId);
        }

        @Override
        public void setGeometry(OGCGeometry geometry) {
            OGCGeometry previousValue = (OGCGeometry)this.geometries.get(this.groupId);
            this.size -= GeometryStateFactory.getGeometryMemorySize(previousValue);
            this.size += GeometryStateFactory.getGeometryMemorySize(geometry);
            this.geometries.set(this.groupId, (Object)geometry);
        }

        public void ensureCapacity(long size) {
            this.geometries.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return this.size + this.geometries.sizeOf();
        }

        public final void setGroupId(long groupId) {
            this.groupId = groupId;
        }
    }
}

