/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import io.airlift.slice.Slice;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.plugin.geospatial.aggregation.GeometryState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;

public class GeometryStateSerializer
implements AccumulatorStateSerializer<GeometryState> {
    public Type getSerializedType() {
        return GeometryType.GEOMETRY;
    }

    public void serialize(GeometryState state, BlockBuilder out) {
        if (state.getGeometry() == null) {
            out.appendNull();
        } else {
            GeometryType.GEOMETRY.writeSlice(out, GeometrySerde.serialize((OGCGeometry)state.getGeometry()));
        }
    }

    public void deserialize(Block block, int index, GeometryState state) {
        state.setGeometry(GeometrySerde.deserialize((Slice)GeometryType.GEOMETRY.getSlice(block, index)));
    }
}

