/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.BytesBytesMultiHashMap;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerDirectAccess;
import org.apache.hadoop.hive.ql.exec.persistence.ReusableGetAdaptorDirectAccess;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedMultiKeyHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;

public abstract class VectorMapJoinOptimizedHashTable
implements VectorMapJoinHashTable {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinOptimizedMultiKeyHashMap.class.getName());
    protected final MapJoinTableContainer originalTableContainer;
    protected final MapJoinTableContainerDirectAccess containerDirectAccess;
    protected final ReusableGetAdaptorDirectAccess adapatorDirectAccess;

    @Override
    public void putRow(BytesWritable currentKey, BytesWritable currentValue) throws SerDeException, HiveException, IOException {
        this.putRowInternal(currentKey, currentValue);
    }

    protected void putRowInternal(BytesWritable key, BytesWritable value) throws SerDeException, HiveException, IOException {
        this.containerDirectAccess.put((Writable)key, (Writable)value);
    }

    public JoinUtil.JoinResult doLookup(byte[] keyBytes, int keyOffset, int keyLength, BytesBytesMultiHashMap.Result bytesBytesMultiHashMapResult, VectorMapJoinHashTableResult hashTableResult) {
        hashTableResult.forget();
        JoinUtil.JoinResult joinResult = this.adapatorDirectAccess.setDirect(keyBytes, keyOffset, keyLength, bytesBytesMultiHashMapResult);
        if (joinResult == JoinUtil.JoinResult.SPILL) {
            hashTableResult.setSpillPartitionId(this.adapatorDirectAccess.directSpillPartitionId());
        }
        hashTableResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinOptimizedHashTable(MapJoinTableContainer originalTableContainer, MapJoinTableContainer.ReusableGetAdaptor hashMapRowGetter) {
        this.originalTableContainer = originalTableContainer;
        this.containerDirectAccess = (MapJoinTableContainerDirectAccess)((Object)originalTableContainer);
        this.adapatorDirectAccess = (ReusableGetAdaptorDirectAccess)((Object)hashMapRowGetter);
    }

    @Override
    public int size() {
        return this.originalTableContainer.size();
    }

    @Override
    public long getEstimatedMemorySize() {
        long size = 0L;
        size += this.originalTableContainer == null ? 0L : this.originalTableContainer.getEstimatedMemorySize();
        return size += (long)(2 * JavaDataModel.get().object());
    }

    public static class SerializedBytes {
        byte[] bytes;
        int offset;
        int length;
    }
}

