/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Arrays;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;

public class JDBCSortPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCSortPushDownRule.class);
    public static final JDBCSortPushDownRule INSTANCE = new JDBCSortPushDownRule();

    public JDBCSortPushDownRule() {
        super(JDBCSortPushDownRule.operand(HiveSortLimit.class, (RelOptRuleOperand)JDBCSortPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperand)JDBCSortPushDownRule.operand(RelNode.class, (RelOptRuleOperandChildren)JDBCSortPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        HiveJdbcConverter conv = (HiveJdbcConverter)call.rel(1);
        for (RexNode currCall : sort.getChildExps()) {
            if (JDBCRexCallValidator.isValidJdbcOperation(currCall, conv.getJdbcDialect())) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        LOG.debug("JDBCSortPushDownRule has been called");
        HiveSortLimit sort = (HiveSortLimit)call.rel(0);
        HiveJdbcConverter converter = (HiveJdbcConverter)call.rel(1);
        RelNode input = call.rel(2);
        HiveSortLimit newHiveSort = sort.copy(sort.getTraitSet(), input, sort.getCollation(), sort.getOffsetExpr(), sort.getFetchExpr());
        JdbcRules.JdbcSort newJdbcSort = (JdbcRules.JdbcSort)new JdbcRules.JdbcSortRule(converter.getJdbcConvention()).convert((Sort)newHiveSort, false);
        if (newJdbcSort != null) {
            RelNode converterRes = converter.copy(converter.getTraitSet(), Arrays.asList(newJdbcSort));
            call.transformTo(converterRes);
        }
    }
}

