/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;

class GoogleHadoopFSInputStream
extends FSInputStream {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private GoogleHadoopFileSystemBase ghfs;
    private final SeekableByteChannel channel;
    private URI gcsPath;
    private long totalBytesRead;
    private final FileSystem.Statistics statistics;
    private long initTime;
    private final byte[] singleReadBuf = new byte[1];

    GoogleHadoopFSInputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, GoogleCloudStorageReadOptions readOptions, FileSystem.Statistics statistics) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GoogleHadoopFSInputStream(gcsPath: %s, readOptions: %s)", (Object)gcsPath, (Object)readOptions);
        this.ghfs = ghfs;
        this.gcsPath = gcsPath;
        this.statistics = statistics;
        this.initTime = System.nanoTime();
        this.totalBytesRead = 0L;
        this.channel = ghfs.getGcsFs().open(gcsPath, readOptions);
    }

    public synchronized int read() throws IOException {
        long startTime = System.nanoTime();
        int numRead = this.channel.read(ByteBuffer.wrap(this.singleReadBuf));
        if (numRead == -1) {
            return -1;
        }
        if (numRead != 1) {
            throw new IOException(String.format("Somehow read %d bytes using single-byte buffer for path %s ending in position %d!", numRead, this.gcsPath, this.channel.position()));
        }
        byte b = this.singleReadBuf[0];
        ++this.totalBytesRead;
        this.statistics.incrementBytesRead(1L);
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ1);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ1_TIME, duration);
        return b & 0xFF;
    }

    public synchronized int read(byte[] buf, int offset, int length) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkNotNull((Object)buf, (Object)"buf must not be null");
        if (offset < 0 || length < 0 || length > buf.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        int numRead = this.channel.read(ByteBuffer.wrap(buf, offset, length));
        if (numRead > 0) {
            this.statistics.incrementBytesRead((long)numRead);
            this.totalBytesRead += (long)numRead;
        }
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_TIME, duration);
        return numRead;
    }

    public synchronized int read(long position, byte[] buf, int offset, int length) throws IOException {
        long startTime = System.nanoTime();
        int result = super.read(position, buf, offset, length);
        if (result > 0) {
            this.statistics.incrementBytesRead((long)result);
            this.totalBytesRead += (long)result;
        }
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_POS);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_POS_TIME, duration);
        return result;
    }

    public synchronized long getPos() throws IOException {
        long pos = this.channel.position();
        ((GoogleLogger.Api)logger.atFine()).log("getPos(): %d", pos);
        return pos;
    }

    public synchronized void seek(long pos) throws IOException {
        long startTime = System.nanoTime();
        ((GoogleLogger.Api)logger.atFine()).log("seek(%d)", pos);
        try {
            this.channel.position(pos);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.SEEK);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.SEEK_TIME, duration);
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized void close() throws IOException {
        ((GoogleLogger.Api)logger.atFinest()).log("close(): %s", (Object)this.gcsPath);
        if (this.channel != null) {
            long startTime = System.nanoTime();
            ((GoogleLogger.Api)logger.atFine()).log("Closing '%s' file with %d total bytes read", (Object)this.gcsPath, this.totalBytesRead);
            this.channel.close();
            long duration = System.nanoTime() - startTime;
            this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_CLOSE);
            this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_CLOSE_TIME, duration);
            long streamDuration = System.nanoTime() - this.initTime;
            this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.INPUT_STREAM);
            this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.INPUT_STREAM_TIME, streamDuration);
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        return super.available();
    }
}

