/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;

public class GoogleHadoopSyncableOutputStream
extends OutputStream
implements Syncable {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String TEMPFILE_PREFIX = "_GCS_SYNCABLE_TEMPFILE_";
    private static final CreateFileOptions TEMPFILE_CREATE_OPTIONS = new CreateFileOptions(false, "application/octet-stream", (Map)CreateFileOptions.EMPTY_ATTRIBUTES, false, false, 0L);
    private static final ExecutorService TEMPFILE_CLEANUP_THREADPOOL = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcs-syncable-output-stream-cleanup-pool-%d").setDaemon(true).build());
    private final GoogleHadoopFileSystemBase ghfs;
    private final URI finalGcsPath;
    private final FileSystem.Statistics statistics;
    private final CreateFileOptions fileOptions;
    private final List<Future<Void>> deletionFutures;
    private final ExecutorService cleanupThreadpool;
    private URI curGcsPath;
    private GoogleHadoopOutputStream curDelegate;
    private int curComponentIndex;
    private long curDestGenerationId;

    public GoogleHadoopSyncableOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, FileSystem.Statistics statistics, CreateFileOptions createFileOptions) throws IOException {
        this(ghfs, gcsPath, statistics, createFileOptions, TEMPFILE_CLEANUP_THREADPOOL, false);
    }

    public GoogleHadoopSyncableOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, FileSystem.Statistics statistics, CreateFileOptions createFileOptions, boolean appendMode) throws IOException {
        this(ghfs, gcsPath, statistics, createFileOptions, TEMPFILE_CLEANUP_THREADPOOL, appendMode);
    }

    GoogleHadoopSyncableOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, FileSystem.Statistics statistics, CreateFileOptions createFileOptions, ExecutorService cleanupThreadpool, boolean appendMode) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GoogleHadoopSyncableOutputStream(gcsPath: %s, createFileOptions:  %s)", (Object)gcsPath, (Object)createFileOptions);
        this.ghfs = ghfs;
        this.finalGcsPath = gcsPath;
        this.statistics = statistics;
        this.fileOptions = createFileOptions;
        this.deletionFutures = new ArrayList<Future<Void>>();
        this.cleanupThreadpool = cleanupThreadpool;
        if (appendMode) {
            this.curGcsPath = this.getNextTemporaryPath();
            this.curComponentIndex = 1;
        } else {
            this.curGcsPath = gcsPath;
            this.curComponentIndex = 0;
        }
        this.curDelegate = new GoogleHadoopOutputStream(ghfs, this.curGcsPath, statistics, this.fileOptions);
        this.curDestGenerationId = -1L;
    }

    @Override
    public void write(int b) throws IOException {
        this.throwIfNotOpen();
        this.curDelegate.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.throwIfNotOpen();
        this.curDelegate.write(b, offset, len);
    }

    @Override
    public void close() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("close(): Current tail file: %s final destination: %s", (Object)this.curGcsPath, (Object)this.finalGcsPath);
        if (!this.isOpen()) {
            ((GoogleLogger.Api)logger.atFinest()).log("close(): Ignoring; stream already closed.");
            return;
        }
        this.commitCurrentFile();
        this.curGcsPath = null;
        this.curDelegate = null;
        ((GoogleLogger.Api)logger.atFine()).log("close(): Awaiting %s deletionFutures", this.deletionFutures.size());
        for (Future<Void> deletion : this.deletionFutures) {
            try {
                deletion.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException("Failed to delete files while closing stream", e);
            }
        }
    }

    public void sync() throws IOException {
        this.hsync();
    }

    public void hflush() throws IOException {
        ((GoogleLogger.Api)logger.atWarning()).log("hflush() is a no-op; readers will *not* yet see flushed data for %s", (Object)this.finalGcsPath);
        this.throwIfNotOpen();
    }

    public void hsync() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("hsync(): Committing tail file %s to final destination %s", (Object)this.curGcsPath, (Object)this.finalGcsPath);
        this.throwIfNotOpen();
        long startTime = System.nanoTime();
        this.commitCurrentFile();
        ++this.curComponentIndex;
        this.curGcsPath = this.getNextTemporaryPath();
        ((GoogleLogger.Api)logger.atFine()).log("hsync(): Opening next temporary tail file %s as component number %s", (Object)this.curGcsPath, this.curComponentIndex);
        this.curDelegate = new GoogleHadoopOutputStream(this.ghfs, this.curGcsPath, this.statistics, TEMPFILE_CREATE_OPTIONS);
        long endTime = System.nanoTime();
        ((GoogleLogger.Api)logger.atFine()).log("Took %d ns to hsync()", endTime - startTime);
    }

    private void commitCurrentFile() throws IOException {
        WritableByteChannel innerChannel = this.curDelegate.getInternalChannel();
        this.curDelegate.close();
        long generationId = -1L;
        if (innerChannel instanceof GoogleCloudStorageItemInfo.Provider) {
            generationId = ((GoogleCloudStorageItemInfo.Provider)innerChannel).getItemInfo().getContentGeneration();
            ((GoogleLogger.Api)logger.atFine()).log("innerChannel is GoogleCloudStorageItemInfo.Provider; closed generationId %s.", generationId);
        } else {
            ((GoogleLogger.Api)logger.atFine()).log("innerChannel NOT instanceof provider: %s", innerChannel.getClass());
        }
        if (!this.finalGcsPath.equals(this.curGcsPath)) {
            StorageResourceId destResourceId = StorageResourceId.fromObjectName((String)this.finalGcsPath.toString(), (long)this.curDestGenerationId);
            StorageResourceId tempResourceId = StorageResourceId.fromObjectName((String)this.curGcsPath.toString(), (long)generationId);
            if (!destResourceId.getBucketName().equals(tempResourceId.getBucketName())) {
                throw new IllegalStateException(String.format("Destination bucket in path '%s' doesn't match temp file bucket in path '%s'", this.finalGcsPath, this.curGcsPath));
            }
            GoogleCloudStorageItemInfo composedObject = this.ghfs.getGcsFs().getGcs().composeObjects((List)ImmutableList.of((Object)destResourceId, (Object)tempResourceId), destResourceId, GoogleCloudStorageFileSystem.objectOptionsFromFileOptions((CreateFileOptions)this.fileOptions));
            this.curDestGenerationId = composedObject.getContentGeneration();
            this.deletionFutures.add(this.cleanupThreadpool.submit(() -> {
                this.ghfs.getGcsFs().getGcs().deleteObjects((List)ImmutableList.of((Object)tempResourceId));
                return null;
            }));
        } else {
            this.curDestGenerationId = generationId;
        }
    }

    private URI getNextTemporaryPath() {
        Path basePath = this.ghfs.getHadoopPath(this.finalGcsPath);
        Path baseDir = basePath.getParent();
        Path tempPath = new Path(baseDir, String.format("%s%s.%d.%s", TEMPFILE_PREFIX, basePath.getName(), this.curComponentIndex, UUID.randomUUID().toString()));
        return this.ghfs.getGcsPath(tempPath);
    }

    private boolean isOpen() {
        return this.curDelegate != null;
    }

    private void throwIfNotOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

