/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryException;
import io.airlift.discovery.client.ExponentialBackOff;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.ConnectException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class Announcer {
    private static final Logger log = Logger.get(Announcer.class);
    private final ConcurrentMap<UUID, ServiceAnnouncement> announcements = new MapMaker().makeMap();
    private final DiscoveryAnnouncementClient announcementClient;
    private final ScheduledExecutorService executor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ExponentialBackOff errorBackOff = new ExponentialBackOff(new Duration(1.0, TimeUnit.MILLISECONDS), new Duration(1.0, TimeUnit.SECONDS), "Discovery server connect succeeded for announce", "Cannot connect to discovery server for announce", log);

    @Inject
    public Announcer(DiscoveryAnnouncementClient announcementClient, Set<ServiceAnnouncement> serviceAnnouncements) {
        Objects.requireNonNull(announcementClient, "client is null");
        Objects.requireNonNull(serviceAnnouncements, "serviceAnnouncements is null");
        this.announcementClient = announcementClient;
        serviceAnnouncements.forEach(this::addServiceAnnouncement);
        this.executor = new ScheduledThreadPoolExecutor(5, Threads.daemonThreadsNamed((String)"Announcer-%s"));
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.executor));
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    public void start() {
        Preconditions.checkState((!this.executor.isShutdown() ? 1 : 0) != 0, (Object)"Announcer has been destroyed");
        if (this.started.compareAndSet(false, true)) {
            ListenableFuture<Duration> announce = this.announce(System.nanoTime(), new Duration(0.0, TimeUnit.SECONDS));
            try {
                announce.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            MoreFutures.getFutureValue(this.announcementClient.unannounce(), DiscoveryException.class);
        }
        catch (DiscoveryException e) {
            if (e.getCause() instanceof ConnectException) {
                log.error("Cannot connect to discovery server for unannounce: %s", new Object[]{e.getCause().getMessage()});
            }
            log.error((Throwable)e);
        }
    }

    public void addServiceAnnouncement(ServiceAnnouncement serviceAnnouncement) {
        Objects.requireNonNull(serviceAnnouncement, "serviceAnnouncement is null");
        this.announcements.put(serviceAnnouncement.getId(), serviceAnnouncement);
    }

    public void removeServiceAnnouncement(UUID serviceId) {
        this.announcements.remove(serviceId);
    }

    public Set<ServiceAnnouncement> getServiceAnnouncements() {
        return ImmutableSet.copyOf(this.announcements.values());
    }

    private ListenableFuture<Duration> announce(long delayStart, final Duration expectedDelay) {
        if (System.nanoTime() - (delayStart + expectedDelay.roundTo(TimeUnit.NANOSECONDS)) > TimeUnit.SECONDS.toNanos(5L)) {
            log.error("Expected service announcement after %s, but announcement was delayed %s", new Object[]{expectedDelay, Duration.nanosSince((long)delayStart)});
        }
        final long requestStart = System.nanoTime();
        ListenableFuture<Duration> future = this.announcementClient.announce(this.getServiceAnnouncements());
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Duration>(){

            public void onSuccess(Duration expectedDelay2) {
                Announcer.this.errorBackOff.success();
                expectedDelay2 = new Duration((double)expectedDelay2.toMillis() * 0.8, TimeUnit.MILLISECONDS);
                log.debug("Service announcement succeeded after %s. Next request will happen within %s", new Object[]{Duration.nanosSince((long)requestStart), expectedDelay2});
                Announcer.this.scheduleNextAnnouncement(expectedDelay2);
            }

            public void onFailure(Throwable t) {
                Duration duration = Announcer.this.errorBackOff.failed(t);
                log.error("Service announcement failed after %s. Next request will happen within %s", new Object[]{Duration.nanosSince((long)requestStart), expectedDelay});
                Announcer.this.scheduleNextAnnouncement(duration);
            }
        }, (Executor)this.executor);
        return future;
    }

    public ListenableFuture<?> forceAnnounce() {
        return this.announcementClient.announce(this.getServiceAnnouncements());
    }

    private void scheduleNextAnnouncement(Duration expectedDelay) {
        if (this.executor.isShutdown()) {
            return;
        }
        long delayStart = System.nanoTime();
        this.executor.schedule(() -> this.announce(delayStart, expectedDelay), expectedDelay.toMillis(), TimeUnit.MILLISECONDS);
    }
}

