/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorIndexHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;

public class ThriftIndexHandle
implements ConnectorIndexHandle {
    private final SchemaTableName schemaTableName;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final Optional<ConnectorSession> session;

    public ThriftIndexHandle(SchemaTableName schemaTableName, TupleDomain<ColumnHandle> tupleDomain, ConnectorSession session) {
        this(schemaTableName, tupleDomain, Optional.of(Objects.requireNonNull(session, "session is null")));
    }

    @JsonCreator
    public ThriftIndexHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain) {
        this(schemaTableName, tupleDomain, Optional.empty());
    }

    private ThriftIndexHandle(SchemaTableName schemaTableName, TupleDomain<ColumnHandle> tupleDomain, Optional<ConnectorSession> session) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftIndexHandle other = (ThriftIndexHandle)obj;
        return Objects.equals(this.schemaTableName, other.schemaTableName) && Objects.equals(this.tupleDomain, other.tupleDomain);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.tupleDomain);
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.schemaTableName;
        objectArray[1] = this.session.map(arg_0 -> this.tupleDomain.toString(arg_0)).orElseGet(() -> this.tupleDomain.toString());
        return String.format("%s, constraint = %s", objectArray);
    }
}

