/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import io.trino.plugin.thrift.ThriftClientModule;
import io.trino.plugin.thrift.ThriftConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Objects;

public class ThriftPlugin
implements Plugin {
    private final String name;
    private final Module module;

    public ThriftPlugin() {
        this("trino-thrift", new ThriftClientModule());
    }

    public ThriftPlugin(String name, Module module) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new ThriftConnectorFactory(this.name, this.module));
    }
}

