/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.thrift.ThriftColumnHandle;
import io.trino.plugin.thrift.api.TrinoThriftColumnMetadata;
import io.trino.plugin.thrift.api.TrinoThriftTableMetadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class ThriftTableMetadata {
    private final SchemaTableName schemaTableName;
    private final List<ColumnMetadata> columns;
    private final Optional<String> comment;
    private final Set<Set<String>> indexableKeys;

    public ThriftTableMetadata(SchemaTableName schemaTableName, List<ColumnMetadata> columns, Optional<String> comment, List<Set<String>> indexableKeys) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.indexableKeys = ThriftTableMetadata.deepImmutableCopy(Objects.requireNonNull(indexableKeys, "indexableKeys is null"));
    }

    public ThriftTableMetadata(TrinoThriftTableMetadata thriftTableMetadata, TypeManager typeManager) {
        this(thriftTableMetadata.getSchemaTableName().toSchemaTableName(), ThriftTableMetadata.columnMetadata(thriftTableMetadata.getColumns(), typeManager), Optional.ofNullable(thriftTableMetadata.getComment()), thriftTableMetadata.getIndexableKeys() != null ? thriftTableMetadata.getIndexableKeys() : ImmutableList.of());
    }

    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public boolean containsIndexableColumns(Set<ColumnHandle> indexableColumns) {
        Set keyColumns = (Set)indexableColumns.stream().map(ThriftColumnHandle.class::cast).map(ThriftColumnHandle::getColumnName).collect(ImmutableSet.toImmutableSet());
        return this.indexableKeys.contains(keyColumns);
    }

    public ConnectorTableMetadata toConnectorTableMetadata() {
        return new ConnectorTableMetadata(this.schemaTableName, this.columns, (Map)ImmutableMap.of(), this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftTableMetadata other = (ThriftTableMetadata)obj;
        return Objects.equals(this.schemaTableName, other.schemaTableName) && Objects.equals(this.columns, other.columns) && Objects.equals(this.comment, other.comment) && Objects.equals(this.indexableKeys, other.indexableKeys);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.columns, this.comment, this.indexableKeys);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaTableName", (Object)this.schemaTableName).add("columns", this.columns).add("comment", this.comment).add("indexableKeys", this.indexableKeys).toString();
    }

    private static List<ColumnMetadata> columnMetadata(List<TrinoThriftColumnMetadata> columns, TypeManager typeManager) {
        return (List)columns.stream().map(column -> column.toColumnMetadata(typeManager)).collect(ImmutableList.toImmutableList());
    }

    private static Set<Set<String>> deepImmutableCopy(List<Set<String>> indexableKeys) {
        return (Set)indexableKeys.stream().map(ImmutableSet::copyOf).collect(ImmutableSet.toImmutableSet());
    }
}

