/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Suppliers;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.ConfigBinder;
import io.airlift.log.Logger;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.security.FileBasedAccessControl;
import io.trino.plugin.base.security.FileBasedAccessControlConfig;
import io.trino.plugin.base.security.ForwardingConnectorAccessControl;
import io.trino.spi.connector.ConnectorAccessControl;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class FileBasedAccessControlModule
implements Module {
    private static final Logger log = Logger.get(FileBasedAccessControlModule.class);

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(FileBasedAccessControlConfig.class);
    }

    @Inject
    @Provides
    public ConnectorAccessControl getConnectorAccessControl(CatalogName catalogName, FileBasedAccessControlConfig config) {
        File configFile = config.getConfigFile();
        if (config.getRefreshPeriod() != null) {
            return ForwardingConnectorAccessControl.of((Supplier<ConnectorAccessControl>)Suppliers.memoizeWithExpiration(() -> {
                log.info("Refreshing access control for catalog '%s' from: %s", new Object[]{catalogName, configFile});
                return new FileBasedAccessControl(catalogName, configFile);
            }, (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        return new FileBasedAccessControl(catalogName, configFile);
    }
}

