/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.rcfile.ValidationHash;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RcFileWriteValidation {
    private final byte version;
    private final Map<String, String> metadata;
    private final Optional<String> codecClassName;
    private final long syncFirst;
    private final long syncSecond;
    private final WriteChecksum checksum;

    private RcFileWriteValidation(byte version, Map<String, String> metadata, Optional<String> codecClassName, long syncFirst, long syncSecond, WriteChecksum checksum) {
        this.version = version;
        this.metadata = ImmutableMap.copyOf(Objects.requireNonNull(metadata, "metadata is null"));
        this.codecClassName = Objects.requireNonNull(codecClassName, "codecClassName is null");
        this.syncFirst = syncFirst;
        this.syncSecond = syncSecond;
        this.checksum = Objects.requireNonNull(checksum, "checksum is null");
    }

    public byte getVersion() {
        return this.version;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Optional<String> getCodecClassName() {
        return this.codecClassName;
    }

    public long getSyncFirst() {
        return this.syncFirst;
    }

    public long getSyncSecond() {
        return this.syncSecond;
    }

    public WriteChecksum getChecksum() {
        return this.checksum;
    }

    public static class WriteChecksum {
        private final long totalRowCount;
        private final long rowGroupHash;
        private final List<Long> columnHashes;

        public WriteChecksum(long totalRowCount, long rowGroupHash, List<Long> columnHashes) {
            this.totalRowCount = totalRowCount;
            this.rowGroupHash = rowGroupHash;
            this.columnHashes = columnHashes;
        }

        public long getTotalRowCount() {
            return this.totalRowCount;
        }

        public long getRowGroupHash() {
            return this.rowGroupHash;
        }

        public List<Long> getColumnHashes() {
            return this.columnHashes;
        }
    }

    public static class RcFileWriteValidationBuilder {
        private byte version;
        private final Map<String, String> metadata = new HashMap<String, String>();
        private Optional<String> codecClassName;
        private long syncFirst;
        private long syncSecond;
        private final WriteChecksumBuilder checksum;

        public RcFileWriteValidationBuilder(List<Type> types) {
            this.checksum = new WriteChecksumBuilder(types);
        }

        public RcFileWriteValidationBuilder setVersion(byte version) {
            this.version = version;
            return this;
        }

        public RcFileWriteValidationBuilder addMetadataProperty(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public RcFileWriteValidationBuilder setCodecClassName(Optional<String> codecClassName) {
            this.codecClassName = codecClassName;
            return this;
        }

        public RcFileWriteValidationBuilder setSyncFirst(long syncFirst) {
            this.syncFirst = syncFirst;
            return this;
        }

        public RcFileWriteValidationBuilder setSyncSecond(long syncSecond) {
            this.syncSecond = syncSecond;
            return this;
        }

        public RcFileWriteValidationBuilder addRowGroup(int rowCount) {
            this.checksum.addRowGroup(rowCount);
            return this;
        }

        public RcFileWriteValidationBuilder addPage(Page page) {
            this.checksum.addPage(page);
            return this;
        }

        public RcFileWriteValidation build() {
            return new RcFileWriteValidation(this.version, this.metadata, this.codecClassName, this.syncFirst, this.syncSecond, this.checksum.build());
        }
    }

    public static class WriteChecksumBuilder {
        private final List<ValidationHash> validationHashes;
        private long totalRowCount;
        private final List<XxHash64> columnHashes;
        private final XxHash64 rowGroupHash = new XxHash64();
        private final byte[] longBuffer = new byte[8];
        private final Slice longSlice = Slices.wrappedBuffer((byte[])this.longBuffer);

        private WriteChecksumBuilder(List<Type> types) {
            this.validationHashes = (List)types.stream().map(ValidationHash::createValidationHash).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder columnHashes = ImmutableList.builder();
            for (Type ignored : types) {
                columnHashes.add((Object)new XxHash64());
            }
            this.columnHashes = columnHashes.build();
        }

        public static WriteChecksumBuilder createWriteChecksumBuilder(Map<Integer, Type> readColumns) {
            Objects.requireNonNull(readColumns, "readColumns is null");
            Preconditions.checkArgument((!readColumns.isEmpty() ? 1 : 0) != 0, (Object)"readColumns is empty");
            int columnCount = readColumns.keySet().stream().mapToInt(Integer::intValue).max().getAsInt() + 1;
            Preconditions.checkArgument((readColumns.size() == columnCount ? 1 : 0) != 0, (Object)"checksum requires all columns to be read");
            ImmutableList.Builder types = ImmutableList.builder();
            for (int column = 0; column < columnCount; ++column) {
                Type type = readColumns.get(column);
                Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"checksum requires all columns to be read");
                types.add((Object)type);
            }
            return new WriteChecksumBuilder((List<Type>)types.build());
        }

        public void addRowGroup(int rowCount) {
            this.longSlice.setInt(0, rowCount);
            this.rowGroupHash.update(this.longBuffer, 0, 4);
        }

        public void addPage(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((page.getChannelCount() == this.columnHashes.size() ? 1 : 0) != 0, (Object)"invalid page");
            this.totalRowCount += (long)page.getPositionCount();
            for (int channel = 0; channel < this.columnHashes.size(); ++channel) {
                ValidationHash validationHash = this.validationHashes.get(channel);
                Block block = page.getBlock(channel);
                XxHash64 xxHash64 = this.columnHashes.get(channel);
                for (int position = 0; position < block.getPositionCount(); ++position) {
                    long hash = validationHash.hash(block, position);
                    this.longSlice.setLong(0, hash);
                    xxHash64.update(this.longBuffer);
                }
            }
        }

        public WriteChecksum build() {
            return new WriteChecksum(this.totalRowCount, this.rowGroupHash.hash(), this.columnHashes.stream().map(XxHash64::hash).collect(Collectors.toList()));
        }
    }
}

