/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.HudiPredicates;
import io.trino.plugin.hudi.HudiSessionProperties;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.HudiTableInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.TableNotFoundException;

public class HudiMetadata
implements ConnectorMetadata {
    public static final Logger log = Logger.get(HudiMetadata.class);
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;

    public HudiMetadata(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.metastore.getAllDatabases().stream().filter(schemaName -> !HiveUtil.isHiveSystemSchema((String)schemaName)).collect(ImmutableList.toImmutableList());
    }

    public HudiTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return null;
        }
        Optional table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table.isEmpty()) {
            return null;
        }
        if (!this.isHudiTable(session, (Table)table.get())) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_UNKNOWN_TABLE_TYPE, String.format("Not a Hudi table: %s", tableName));
        }
        return new HudiTableHandle(tableName.getSchemaName(), tableName.getTableName(), ((Table)table.get()).getStorage().getLocation(), HoodieTableType.COPY_ON_WRITE, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), (TupleDomain<HiveColumnHandle>)TupleDomain.all());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        HudiTableHandle hudiTableHandle = (HudiTableHandle)table;
        return this.getTableMetadata(hudiTableHandle.getSchemaTableName(), HudiSessionProperties.getColumnsToHide(session));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        HudiTableHandle handle = (HudiTableHandle)tableHandle;
        HudiPredicates predicates = HudiPredicates.from((TupleDomain<ColumnHandle>)constraint.getSummary());
        HudiTableHandle newHudiTableHandle = handle.applyPredicates(predicates.getPartitionColumnPredicates(), predicates.getRegularColumnPredicates());
        if (handle.getPartitionPredicates().equals(newHudiTableHandle.getPartitionPredicates()) && handle.getRegularPredicates().equals(newHudiTableHandle.getRegularPredicates())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHudiTableHandle, newHudiTableHandle.getRegularPredicates().transformKeys(ColumnHandle.class::cast), false));
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HudiTableHandle hudiTableHandle = (HudiTableHandle)tableHandle;
        Table table = (Table)this.metastore.getTable(hudiTableHandle.getSchemaName(), hudiTableHandle.getTableName()).orElseThrow(() -> new io.trino.spi.connector.TableNotFoundException(SchemaTableName.schemaTableName((String)hudiTableHandle.getSchemaName(), (String)hudiTableHandle.getTableName())));
        return (Map)HiveUtil.hiveColumnHandles((Table)table, (TypeManager)this.typeManager, (HiveTimestampPrecision)HiveTimestampPrecision.NANOSECONDS).stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata();
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        return Optional.of(HudiTableInfo.from((HudiTableHandle)table));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllTables(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List tables = prefix.getTable().map(ignored -> Collections.singletonList(prefix.toSchemaTableName())).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        return tables.stream().map(table -> this.getTableColumnMetadata(session, (SchemaTableName)table)).flatMap(Optional::stream).iterator();
    }

    HiveMetastore getMetastore() {
        return this.metastore;
    }

    private boolean isHudiTable(ConnectorSession session, Table table) {
        String basePath = table.getStorage().getLocation();
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsContext(session), new Path(basePath));
        try {
            TableNotFoundException.checkTableValidity((FileSystem)FSUtils.getFs((String)basePath, (Configuration)configuration), (Path)new Path(basePath), (Path)new Path(basePath, ".hoodie"));
        }
        catch (TableNotFoundException e) {
            log.warn("Could not find Hudi table at path '%s'", new Object[]{basePath});
            return false;
        }
        return true;
    }

    private Optional<TableColumnsMetadata> getTableColumnMetadata(ConnectorSession session, SchemaTableName table) {
        try {
            List columns = this.getTableMetadata(table, HudiSessionProperties.getColumnsToHide(session)).getColumns();
            return Optional.of(TableColumnsMetadata.forTable((SchemaTableName)table, (List)columns));
        }
        catch (io.trino.spi.connector.TableNotFoundException ignored) {
            return Optional.empty();
        }
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName, Collection<String> columnsToHide) {
        List partitionedBy;
        Table table = (Table)this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new io.trino.spi.connector.TableNotFoundException(tableName));
        Function metadataGetter = HiveUtil.columnMetadataGetter((Table)table);
        List columns = (List)HiveUtil.hiveColumnHandles((Table)table, (TypeManager)this.typeManager, (HiveTimestampPrecision)HiveTimestampPrecision.NANOSECONDS).stream().filter(column -> !columnsToHide.contains(column.getName())).map(metadataGetter).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder properties = ImmutableMap.builder();
        String location = table.getStorage().getLocation();
        if (!StringUtils.isNullOrEmpty((String)location)) {
            properties.put((Object)"location", (Object)location);
        }
        if (!(partitionedBy = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList())).isEmpty()) {
            properties.put((Object)"partitioned_by", (Object)partitionedBy);
        }
        Optional<String> comment = Optional.ofNullable((String)table.getParameters().get("comment"));
        return new ConnectorTableMetadata(tableName, columns, (Map)properties.buildOrThrow(), comment);
    }

    private List<String> listSchemas(ConnectorSession session, Optional<String> schemaName) {
        return schemaName.filter(name -> !HiveUtil.isHiveSystemSchema((String)name)).map(Collections::singletonList).orElseGet(() -> this.listSchemaNames(session));
    }
}

