/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.AsyncQueue;
import io.trino.plugin.hive.util.ThrottledAsyncQueue;
import io.trino.plugin.hudi.HudiSessionProperties;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.query.HudiReadOptimizedDirectoryLister;
import io.trino.plugin.hudi.split.HudiBackgroundSplitLoader;
import io.trino.plugin.hudi.split.HudiSplitWeightProvider;
import io.trino.plugin.hudi.split.SizeBasedSplitWeightProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;

public class HudiSplitSource
implements ConnectorSplitSource {
    private final AsyncQueue<ConnectorSplit> queue;
    private final AtomicReference<TrinoException> trinoException = new AtomicReference();

    public HudiSplitSource(ConnectorSession session, HiveMetastore metastore, Table table, HudiTableHandle tableHandle, Configuration configuration, Map<String, HiveColumnHandle> partitionColumnHandleMap, ExecutorService executor, int maxSplitsPerSecond, int maxOutstandingSplits) {
        boolean metadataEnabled = HudiSessionProperties.isHudiMetadataEnabled(session);
        HoodieTableMetaClient metaClient = HudiSplitSource.buildTableMetaClient(configuration, tableHandle.getBasePath());
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(configuration);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(metadataEnabled).build();
        List<HiveColumnHandle> partitionColumnHandles = table.getPartitionColumns().stream().map(column -> (HiveColumnHandle)partitionColumnHandleMap.get(column.getName())).collect(Collectors.toList());
        HudiReadOptimizedDirectoryLister hudiDirectoryLister = new HudiReadOptimizedDirectoryLister(metadataConfig, (HoodieEngineContext)engineContext, tableHandle, metaClient, metastore, table, partitionColumnHandles);
        this.queue = new ThrottledAsyncQueue(maxSplitsPerSecond, maxOutstandingSplits, (Executor)executor);
        HudiBackgroundSplitLoader splitLoader = new HudiBackgroundSplitLoader(session, tableHandle, hudiDirectoryLister, this.queue, executor, HudiSplitSource.createSplitWeightProvider(session), throwable -> {
            this.trinoException.compareAndSet(null, new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to generate splits for " + table.getTableName(), throwable));
            this.queue.finish();
        });
        splitLoader.start();
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        boolean noMoreSplits = this.isFinished();
        Throwable throwable = (Throwable)this.trinoException.get();
        if (throwable != null) {
            return CompletableFuture.failedFuture(throwable);
        }
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.transform((ListenableFuture)this.queue.getBatchAsync(maxSize), splits -> new ConnectorSplitSource.ConnectorSplitBatch(splits, noMoreSplits), (Executor)MoreExecutors.directExecutor()));
    }

    public void close() {
        this.queue.finish();
    }

    public boolean isFinished() {
        return this.queue.isFinished();
    }

    private static HoodieTableMetaClient buildTableMetaClient(Configuration configuration, String basePath) {
        HoodieTableMetaClient client = HoodieTableMetaClient.builder().setConf(configuration).setBasePath(basePath).build();
        client.getTableConfig().setValue("hoodie.bootstrap.index.enable", "false");
        return client;
    }

    private static HudiSplitWeightProvider createSplitWeightProvider(ConnectorSession session) {
        if (HudiSessionProperties.isSizeBasedSplitWeightsEnabled(session)) {
            DataSize standardSplitWeightSize = HudiSessionProperties.getStandardSplitWeightSize(session);
            double minimumAssignedSplitWeight = HudiSessionProperties.getMinimumAssignedSplitWeight(session);
            return new SizeBasedSplitWeightProvider(minimumAssignedSplitWeight, standardSplitWeightSize);
        }
        return HudiSplitWeightProvider.uniformStandardWeightProvider();
    }
}

