/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.trino.plugin.raptor.legacy.RaptorMetadata;
import io.trino.plugin.raptor.legacy.RaptorMetadataFactory;
import io.trino.plugin.raptor.legacy.RaptorNodePartitioningProvider;
import io.trino.plugin.raptor.legacy.RaptorPageSinkProvider;
import io.trino.plugin.raptor.legacy.RaptorPageSourceProvider;
import io.trino.plugin.raptor.legacy.RaptorSessionProperties;
import io.trino.plugin.raptor.legacy.RaptorSplitManager;
import io.trino.plugin.raptor.legacy.RaptorTableProperties;
import io.trino.plugin.raptor.legacy.RaptorTransactionHandle;
import io.trino.plugin.raptor.legacy.metadata.ForMetadata;
import io.trino.plugin.raptor.legacy.metadata.MetadataDao;
import io.trino.plugin.raptor.legacy.util.DatabaseUtil;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.jdbi.v3.core.Jdbi;

public class RaptorConnector
implements Connector {
    private static final Logger log = Logger.get(RaptorConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final RaptorMetadataFactory metadataFactory;
    private final RaptorSplitManager splitManager;
    private final RaptorPageSourceProvider pageSourceProvider;
    private final RaptorPageSinkProvider pageSinkProvider;
    private final RaptorNodePartitioningProvider nodePartitioningProvider;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final Set<SystemTable> systemTables;
    private final MetadataDao dao;
    private final Optional<ConnectorAccessControl> accessControl;
    private final boolean coordinator;
    private final ConcurrentMap<ConnectorTransactionHandle, RaptorMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, RaptorMetadata>();
    private final ScheduledExecutorService unblockMaintenanceExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"raptor-unblock-maintenance"));
    @GuardedBy(value="this")
    private final SetMultimap<Long, UUID> deletions = HashMultimap.create();

    @Inject
    public RaptorConnector(LifeCycleManager lifeCycleManager, NodeManager nodeManager, RaptorMetadataFactory metadataFactory, RaptorSplitManager splitManager, RaptorPageSourceProvider pageSourceProvider, RaptorPageSinkProvider pageSinkProvider, RaptorNodePartitioningProvider nodePartitioningProvider, RaptorSessionProperties sessionProperties, RaptorTableProperties tableProperties, Set<SystemTable> systemTables, Optional<ConnectorAccessControl> accessControl, @ForMetadata Jdbi dbi) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.sessionProperties = sessionProperties.getSessionProperties();
        this.tableProperties = tableProperties.getTableProperties();
        this.systemTables = Objects.requireNonNull(systemTables, "systemTables is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.dao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        this.coordinator = nodeManager.getCurrentNode().isCoordinator();
    }

    @PostConstruct
    public void start() {
        if (this.coordinator) {
            this.dao.unblockAllMaintenance();
        }
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        RaptorTransactionHandle transaction = new RaptorTransactionHandle();
        this.transactions.put(transaction, this.metadataFactory.create(tableId -> this.beginDelete(tableId, transaction.getUuid())));
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        this.finishDelete(((RaptorTransactionHandle)transaction).getUuid());
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        RaptorMetadata metadata = (RaptorMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        this.finishDelete(((RaptorTransactionHandle)transaction).getUuid());
        metadata.rollback();
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        RaptorMetadata metadata = (RaptorMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl.orElseThrow(UnsupportedOperationException::new);
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }

    private synchronized void beginDelete(long tableId, UUID transactionId) {
        this.dao.blockMaintenance(tableId);
        Verify.verify((boolean)this.deletions.put((Object)tableId, (Object)transactionId));
    }

    private synchronized void finishDelete(UUID transactionId) {
        this.deletions.entries().stream().filter(entry -> ((UUID)entry.getValue()).equals(transactionId)).findFirst().ifPresent(entry -> {
            long tableId = (Long)entry.getKey();
            this.deletions.remove((Object)tableId, (Object)transactionId);
            if (!this.deletions.containsKey((Object)tableId)) {
                this.unblockMaintenance(tableId);
            }
        });
    }

    private void unblockMaintenance(long tableId) {
        try {
            this.dao.unblockMaintenance(tableId);
        }
        catch (Throwable t) {
            log.warn(t, "Failed to unblock maintenance for table ID %s, will retry", new Object[]{tableId});
            this.unblockMaintenanceExecutor.schedule(() -> this.unblockMaintenance(tableId), 2L, TimeUnit.SECONDS);
        }
    }
}

