/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import io.trino.plugin.raptor.legacy.metadata.ColumnMetadataRow;
import io.trino.plugin.raptor.legacy.metadata.Distribution;
import io.trino.plugin.raptor.legacy.metadata.SchemaTableNameMapper;
import io.trino.plugin.raptor.legacy.metadata.Table;
import io.trino.plugin.raptor.legacy.metadata.TableColumn;
import io.trino.plugin.raptor.legacy.metadata.TableMetadataRow;
import io.trino.plugin.raptor.legacy.metadata.TableStatsRow;
import io.trino.plugin.raptor.legacy.metadata.ViewResult;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Set;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMappers;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMappers;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterConstructorMappers(value={@RegisterConstructorMapper(value=ColumnMetadataRow.class), @RegisterConstructorMapper(value=TableMetadataRow.class), @RegisterConstructorMapper(value=TableStatsRow.class)})
@RegisterRowMappers(value={@RegisterRowMapper(value=SchemaTableNameMapper.class), @RegisterRowMapper(value=Table.TableMapper.class), @RegisterRowMapper(value=ViewResult.Mapper.class)})
public interface MetadataDao {
    public static final String TABLE_INFORMATION_SELECT = "SELECT t.table_id, t.distribution_id, d.distribution_name, d.bucket_count, t.temporal_column_id, t.organization_enabled\nFROM tables t\nLEFT JOIN distributions d ON (t.distribution_id = d.distribution_id)\n";
    public static final String TABLE_COLUMN_SELECT = "SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\n";

    @SqlQuery(value="SELECT t.table_id, t.distribution_id, d.distribution_name, d.bucket_count, t.temporal_column_id, t.organization_enabled\nFROM tables t\nLEFT JOIN distributions d ON (t.distribution_id = d.distribution_id)\nWHERE t.table_id = :tableId")
    public Table getTableInformation(long var1);

    @SqlQuery(value="SELECT t.table_id, t.distribution_id, d.distribution_name, d.bucket_count, t.temporal_column_id, t.organization_enabled\nFROM tables t\nLEFT JOIN distributions d ON (t.distribution_id = d.distribution_id)\nWHERE t.schema_name = :schemaName\n  AND t.table_name = :tableName")
    public Table getTableInformation(String var1, String var2);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.column_id = :columnId\nORDER BY c.ordinal_position\n")
    public TableColumn getTableColumn(long var1, long var3);

    @SqlQuery(value="SELECT schema_name, table_name\nFROM tables\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)")
    public List<SchemaTableName> listTables(String var1);

    @SqlQuery(value="SELECT DISTINCT schema_name FROM tables")
    public List<String> listSchemaNames();

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name, ordinal_position")
    public List<TableColumn> listTableColumns(String var1, String var2);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\nORDER BY c.ordinal_position")
    public List<TableColumn> listTableColumns(long var1);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.sort_ordinal_position IS NOT NULL\nORDER BY c.sort_ordinal_position")
    public List<TableColumn> listSortColumns(long var1);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.bucket_ordinal_position IS NOT NULL\nORDER BY c.bucket_ordinal_position")
    public List<TableColumn> listBucketColumns(long var1);

    @SqlQuery(value="SELECT schema_name, table_name, data\nFROM views\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)")
    public List<SchemaTableName> listViews(String var1);

    @SqlQuery(value="SELECT schema_name, table_name, data\nFROM views\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name\n")
    public List<ViewResult> getViews(String var1, String var2);

    @SqlUpdate(value="INSERT INTO tables (\n  schema_name, table_name, compaction_enabled, organization_enabled, distribution_id,\n  create_time, update_time, table_version,\n  shard_count, row_count, compressed_size, uncompressed_size)\nVALUES (\n  :schemaName, :tableName, :compactionEnabled, :organizationEnabled, :distributionId,\n  :createTime, :createTime, 0,\n  0, 0, 0, 0)\n")
    @GetGeneratedKeys
    public long insertTable(String var1, String var2, boolean var3, boolean var4, Long var5, long var6);

    @SqlUpdate(value="UPDATE tables SET\n  update_time = :updateTime\n, table_version = table_version + 1\nWHERE table_id = :tableId")
    public void updateTableVersion(long var1, long var3);

    @SqlUpdate(value="UPDATE tables SET\n  shard_count = shard_count + :shardCount \n, row_count = row_count + :rowCount\n, compressed_size = compressed_size + :compressedSize\n, uncompressed_size = uncompressed_size + :uncompressedSize\nWHERE table_id = :tableId")
    public void updateTableStats(long var1, long var3, long var5, long var7, long var9);

    @SqlUpdate(value="INSERT INTO columns (table_id, column_id, column_name, ordinal_position, data_type, sort_ordinal_position, bucket_ordinal_position)\nVALUES (:tableId, :columnId, :columnName, :ordinalPosition, :dataType, :sortOrdinalPosition, :bucketOrdinalPosition)")
    public void insertColumn(long var1, long var3, String var5, int var6, String var7, Integer var8, Integer var9);

    @SqlUpdate(value="UPDATE tables SET\n  schema_name = :newSchemaName\n, table_name = :newTableName\nWHERE table_id = :tableId")
    public void renameTable(long var1, String var3, String var4);

    @SqlUpdate(value="UPDATE columns SET column_name = :target\nWHERE table_id = :tableId\n  AND column_id = :columnId")
    public void renameColumn(long var1, long var3, String var5);

    @SqlUpdate(value="DELETE FROM columns\n WHERE table_id = :tableId\n  AND column_id = :columnId")
    public void dropColumn(long var1, long var3);

    @SqlUpdate(value="INSERT INTO views (schema_name, table_name, data)\nVALUES (:schemaName, :tableName, :data)")
    public void insertView(String var1, String var2, String var3);

    @SqlUpdate(value="DELETE FROM tables WHERE table_id = :tableId")
    public int dropTable(long var1);

    @SqlUpdate(value="DELETE FROM columns WHERE table_id = :tableId")
    public int dropColumns(long var1);

    @SqlUpdate(value="DELETE FROM views\nWHERE schema_name = :schemaName\n  AND table_name = :tableName")
    public int dropView(String var1, String var2);

    @SqlQuery(value="SELECT temporal_column_id\nFROM tables\nWHERE table_id = :tableId")
    public Long getTemporalColumnId(long var1);

    @SqlUpdate(value="UPDATE tables SET\ntemporal_column_id = :columnId\nWHERE table_id = :tableId")
    public void updateTemporalColumnId(long var1, long var3);

    @SqlQuery(value="SELECT compaction_enabled AND maintenance_blocked IS NULL\nFROM tables\nWHERE table_id = :tableId")
    public boolean isCompactionEligible(long var1);

    @SqlQuery(value="SELECT table_id FROM tables WHERE table_id = :tableId FOR UPDATE")
    public Long getLockedTableId(long var1);

    @SqlQuery(value="SELECT distribution_id, distribution_name, column_types, bucket_count\nFROM distributions\nWHERE distribution_id = :distributionId")
    public Distribution getDistribution(long var1);

    @SqlQuery(value="SELECT distribution_id, distribution_name, column_types, bucket_count\nFROM distributions\nWHERE distribution_name = :distributionName")
    public Distribution getDistribution(String var1);

    @SqlUpdate(value="INSERT INTO distributions (distribution_name, column_types, bucket_count)\nVALUES (:distributionName, :columnTypes, :bucketCount)")
    @GetGeneratedKeys
    public long insertDistribution(String var1, String var2, int var3);

    @SqlQuery(value="SELECT table_id, schema_name, table_name, temporal_column_id, distribution_name, bucket_count, organization_enabled\nFROM tables\nLEFT JOIN distributions\nON tables.distribution_id = distributions.distribution_id\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY table_id")
    public List<TableMetadataRow> getTableMetadataRows(String var1, String var2);

    @SqlQuery(value="SELECT table_id, column_id, column_name, sort_ordinal_position, bucket_ordinal_position\nFROM columns\nWHERE table_id IN (\n  SELECT table_id\n  FROM tables\n  WHERE (schema_name = :schemaName OR :schemaName IS NULL)\n    AND (table_name = :tableName OR :tableName IS NULL))\nORDER BY table_id")
    public List<ColumnMetadataRow> getColumnMetadataRows(String var1, String var2);

    @SqlQuery(value="SELECT schema_name, table_name, create_time, update_time, table_version,\n  shard_count, row_count, compressed_size, uncompressed_size\nFROM tables\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name")
    public List<TableStatsRow> getTableStatsRows(String var1, String var2);

    @SqlQuery(value="SELECT table_id\nFROM tables\nWHERE organization_enabled\n  AND maintenance_blocked IS NULL\n  AND table_id IN\n       (SELECT table_id\n        FROM columns\n        WHERE sort_ordinal_position IS NOT NULL)")
    public Set<Long> getOrganizationEligibleTables();

    @SqlUpdate(value="UPDATE tables SET maintenance_blocked = CURRENT_TIMESTAMP\nWHERE table_id = :tableId\n  AND maintenance_blocked IS NULL")
    public void blockMaintenance(long var1);

    @SqlUpdate(value="UPDATE tables SET maintenance_blocked = NULL\nWHERE table_id = :tableId")
    public void unblockMaintenance(long var1);

    @SqlQuery(value="SELECT maintenance_blocked IS NOT NULL\nFROM tables\nWHERE table_id = :tableId\nFOR UPDATE")
    public boolean isMaintenanceBlockedLocked(long var1);

    @SqlUpdate(value="UPDATE tables SET maintenance_blocked = NULL\nWHERE maintenance_blocked IS NOT NULL")
    public void unblockAllMaintenance();
}

