/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.raptor.legacy.RaptorColumnHandle;
import io.trino.plugin.raptor.legacy.metadata.DatabaseShardManager;
import io.trino.plugin.raptor.legacy.storage.ColumnIndexStatsUtils;
import io.trino.plugin.raptor.legacy.storage.ShardStats;
import io.trino.plugin.raptor.legacy.util.UuidUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

class ShardPredicate {
    private final String predicate;
    private final List<JDBCType> types;
    private final List<Object> values;
    private static final int MAX_RANGE_COUNT = 100;

    private ShardPredicate(String predicate, List<JDBCType> types, List<Object> values) {
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
        Preconditions.checkArgument((types.size() == values.size() ? 1 : 0) != 0, (Object)"types and values sizes do not match");
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void bind(PreparedStatement statement) throws SQLException {
        for (int i = 0; i < this.types.size(); ++i) {
            JDBCType type = this.types.get(i);
            Object value = this.values.get(i);
            ShardPredicate.bindValue(statement, type, value, i + 1);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.predicate).toString();
    }

    public static ShardPredicate create(TupleDomain<RaptorColumnHandle> tupleDomain) {
        StringJoiner predicate = new StringJoiner(" AND ").setEmptyValue("true");
        ImmutableList.Builder types = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        for (Map.Entry entry : ((Map)tupleDomain.getDomains().get()).entrySet()) {
            RaptorColumnHandle handle;
            Type type;
            JDBCType jdbcType;
            Domain domain = (Domain)entry.getValue();
            if (domain.isNullAllowed() || domain.isAll() || (jdbcType = ColumnIndexStatsUtils.jdbcType(type = (handle = (RaptorColumnHandle)entry.getKey()).getColumnType())) == null) continue;
            if (handle.isShardUuid()) {
                predicate.add(ShardPredicate.createShardPredicate((ImmutableList.Builder<JDBCType>)types, (ImmutableList.Builder<Object>)values, domain, jdbcType));
                continue;
            }
            if (!domain.getType().isOrderable()) continue;
            StringJoiner columnPredicate = new StringJoiner(" OR ", "(", ")").setEmptyValue("true");
            Ranges ranges = domain.getValues().getRanges();
            if (ranges.getRangeCount() > 100) continue;
            for (Range range : ranges.getOrderedRanges()) {
                String max;
                String min;
                if (handle.isBucketNumber()) {
                    min = "bucket_number";
                    max = "bucket_number";
                } else {
                    min = DatabaseShardManager.minColumn(handle.getColumnId());
                    max = DatabaseShardManager.maxColumn(handle.getColumnId());
                }
                StringJoiner rangePredicate = new StringJoiner(" AND ", "(", ")").setEmptyValue("true");
                if (!range.isLowUnbounded()) {
                    rangePredicate.add(String.format("(%s >= ? OR %s IS NULL)", max, max));
                    types.add((Object)jdbcType);
                    values.add(range.getLowBoundedValue());
                }
                if (!range.isHighUnbounded()) {
                    rangePredicate.add(String.format("(%s <= ? OR %s IS NULL)", min, min));
                    types.add((Object)jdbcType);
                    values.add(range.getHighBoundedValue());
                }
                columnPredicate.add(rangePredicate.toString());
            }
            predicate.add(columnPredicate.toString());
        }
        return new ShardPredicate(predicate.toString(), (List<JDBCType>)types.build(), (List<Object>)values.build());
    }

    private static String createShardPredicate(ImmutableList.Builder<JDBCType> types, ImmutableList.Builder<Object> values, Domain domain, JDBCType jdbcType) {
        List ranges = domain.getValues().getRanges().getOrderedRanges();
        if (ranges.isEmpty() || !ranges.stream().allMatch(Range::isSingleValue)) {
            return "true";
        }
        ImmutableList.Builder valuesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        StringJoiner rangePredicate = new StringJoiner(" OR ");
        for (Range range : ranges) {
            Slice uuidText = (Slice)range.getSingleValue();
            try {
                Slice uuidBytes = UuidUtil.uuidStringToBytes(uuidText);
                typesBuilder.add((Object)jdbcType);
                valuesBuilder.add((Object)uuidBytes);
            }
            catch (IllegalArgumentException e) {
                return "true";
            }
            rangePredicate.add("shard_uuid = ?");
        }
        types.addAll((Iterable)typesBuilder.build());
        values.addAll((Iterable)valuesBuilder.build());
        return rangePredicate.toString();
    }

    @VisibleForTesting
    protected List<JDBCType> getTypes() {
        return this.types;
    }

    @VisibleForTesting
    protected List<Object> getValues() {
        return this.values;
    }

    public static void bindValue(PreparedStatement statement, JDBCType type, Object value, int index) throws SQLException {
        if (value == null) {
            statement.setNull(index, type.getVendorTypeNumber());
            return;
        }
        switch (type) {
            case BOOLEAN: {
                statement.setBoolean(index, (Boolean)value);
                return;
            }
            case INTEGER: {
                statement.setInt(index, ((Number)value).intValue());
                return;
            }
            case BIGINT: {
                statement.setLong(index, ((Number)value).longValue());
                return;
            }
            case DOUBLE: {
                statement.setDouble(index, ((Number)value).doubleValue());
                return;
            }
            case VARBINARY: {
                statement.setBytes(index, ShardStats.truncateIndexValue((Slice)value).getBytes());
                return;
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type: " + type);
    }
}

